---
tags:
- research
---

- [x] `analysis` [[@Raginsky2019May]] [completion:: 2023-07-19]
- [x] `summarize current results in to LaTeX` [completion:: 2023-07-22]
- [x] `implement the likelihood function` [completion:: 2023-07-20]
- [x] `run simulation` [completion:: 2023-07-24]
- [x] #writing update the example 1 results
- [x] #writing update the example 1 SDE results
- [x] #coding analyze the reconstructed dynamics [completion:: 2023-08-05]
- [x] #coding `neural sde fitting for example 1` [completion:: 2023-07-30]
- [x] #coding `[1d_example 49fcfcb]` switch to torchsde [completion:: 2023-08-06]
- [x] #coding $n_{\rm training}, n_{\rm testing} \in \left\{ 50,100,200,400 \right\}$. $n_r$ [completion:: 2023-08-07]
- [x] #coding $\sigma \in 0.1:0.1:1$. [completion:: 2023-08-10]
- [x] #coding debug [completion:: 2023-08-10]
- [x] simulation [completion:: 2023-08-14]
- [x] #analysis summarize example 2 results [completion:: 2023-08-20]
- [x] #coding Implement WGAN loss [completion:: 2023-08-13]
- [x] #coding Implement MMD loss [completion:: 2023-08-13]
- [x] Discussion [completion:: 2023-08-15]
- [x] Implement Fixed Initial Condition Temporal OU process in [[@Lyons2021Feb]]. [completion:: 2023-08-20]
- [x] #coding Change the method of evaluating the performance indicator to [[Wasserstein#performance indicator]]. [completion:: 2023-08-20]
- [x] #simulation Run the simulation for [[#Temporal OU model]] with $L=512,1024$. [completion:: 2023-08-22]
- [x] #coding [[Wasserstein GAN]] for [[#Temporal OU model]] [completion:: 2023-08-22]
- [x] #simulation Implement the example 2D case. [completion:: 2023-08-23]
- [x] #coding Hyperparameter tuning for [[#Geometric Brownian Motion]] [completion:: 2023-08-26]
- [x] #simulation Run the simulation for [[#Geometric Brownian Motion]] [completion:: 2023-08-24]
- [x] #writing Figure for [[#Temporal OU model]] [completion:: 2023-08-24]
- [x] #writing Figure for [[#Geometric Brownian Motion]] [completion:: 2023-08-26]
- [x] #coding Sensitivity test for N in rotating W2 loss. [completion:: 2023-08-27]
- [x] [[#CIR model]] [completion:: 2023-09-01]
	- [x] IC: $y_0 \sim \mathcal{N}\left(0, \delta^2\right)$ for $\delta \in 0.1, \ldots, 1$; [completion:: 2023-08-31]
	- [x] NN structure: Change hidden layer width $\{16,32,64,128\}$; [completion:: 2023-08-31]
	- [x] NN structure: Change hidden layer depth $\{1,2,3,4\}$; [completion:: 2023-09-01]
	- [x] Regularization: Resnet; normalization in time; [completion:: 2023-09-01]
- [x] [[#Temporal OU model]] [completion:: 2023-09-06]
	- [x] SGD + tuning [completion:: 2023-09-06]
- [x] [[#Geometric Brownian Motion]] [completion:: 2023-09-02]
	- [x] Change number of rotations: 1~ 9 [completion:: 2023-09-02]
- [x] Figure revision [completion:: 2023-09-08]
- [x] Text revision [completion:: 2023-09-10]
- [x] Write a readme [completion:: 2023-09-14]
- [x] Update dashed line in figures and $W_2$ notations [completion:: 2023-09-14]
- [x] Grid example [completion:: 2023-09-14]
- [x] Int sign [completion:: 2023-09-20]
- [x] Improve English and Accuracy in Appendix [completion:: 2023-09-20]
- [ ] Implement and test decoupled W2

### CIR model
CIR Model Formula
The equation for the CIR model is expressed as follows:
$$
d r_t=a\left(b-r_t\right) d t+\sigma \sqrt{r_t} d W_t
$$
where:
$r t=$ Instantaneous interest rate at time $t$
$a=$ Rate of mean reversion
$b=$ Mean of the interest rate
$W_t=$ Wiener process (random variable modeling the market risk factor)
$\sigma=$ Standard deviation of the interest rate (measure of volatility)

### Temporal OU model

#### Performance indicator
Let's use $x_i(t_j)$ to represent the sample trajectories. Then the reconstructed error is evaluated by
$$
\frac{\sum_{i,j}\|\hat f(x_i(t_j)) - f\big(x_i(t_j)\big)\|^2_2}{\sum_{i,j}\|\hat f(x_i(t_j))\|^2_2}
$$

Code:
```python
def rel_err_f(neuralsde, sde, u_truth, ts):
    """
    Compute the relative error between the estimated drift from neuralsde and the true drift from sde for each trajectory sample.
    """
    t_size, sample_size, n = u_truth.shape
    
    # Interleave u_truth and ts for correct pairing
    u_truth_reshaped = u_truth.permute(1, 0, 2).reshape(-1, n)
    ts_repeated = ts.unsqueeze(0).repeat(sample_size, 1).reshape(-1)
    
    # Compute the estimated drift component for each trajectory sample from neuralsde
    f_hat_vals = f(neuralsde, u_truth_reshaped, ts_repeated).reshape(sample_size, t_size, n).permute(1, 0, 2)
    
    # Compute the true drift component for each trajectory sample from sde
    f_vals = f(sde, u_truth_reshaped, ts_repeated).reshape(sample_size, t_size, n).permute(1, 0, 2)
    
    # Compute the squared error between the estimated and true drift components
    squared_error = torch.norm(f_hat_vals - f_vals, dim=-1)**2
    
    # Compute the squared magnitude of the true drift component
    squared_norm_f = torch.norm(f_vals, dim=-1)**2
    
    # Compute the relative error
    rel_error = torch.sum(squared_error) / torch.sum(squared_norm_f)
    
    return rel_error

```

Validation for the interleaving 
```python
import torch

# Sample data
t_size = 3
sample_size = 2
n = 4

# Mock u_truth tensor
u_truth = torch.arange(t_size * sample_size * n).reshape(t_size, sample_size, n)

# Mock ts tensor
ts = torch.tensor([0.1, 0.5, 0.9])

# Interleave u_truth and ts for correct pairing
u_truth_reshaped = u_truth.permute(1, 0, 2).reshape(-1, n)
ts_repeated = ts.unsqueeze(0).repeat(sample_size, 1).reshape(-1)

u_truth, ts, u_truth_reshaped, ts_repeated
(tensor([[[ 0,  1,  2,  3],
          [ 4,  5,  6,  7]],
 
         [[ 8,  9, 10, 11],
          [12, 13, 14, 15]],
 
         [[16, 17, 18, 19],
          [20, 21, 22, 23]]]),
 tensor([0.1000, 0.5000, 0.9000]),
 tensor([[ 0,  1,  2,  3],
         [ 8,  9, 10, 11],
         [16, 17, 18, 19],
         [ 4,  5,  6,  7],
         [12, 13, 14, 15],
         [20, 21, 22, 23]]),
 tensor([0.1000, 0.5000, 0.9000, 0.1000, 0.5000, 0.9000]))
```

### Geometric Brownian Motion
This is a two dimensional example.

In the following plots, black = ground truth, red = predicted values. The plots show 50 trajectories as well as $f(x,y)$. Note that $\Sigma(x,y)$ is not shown.

Both W2 and MMD losses leads to systematic errors in $\Sigma$ reconstruction.

To evaluate the relative loss for $\Sigma$, we compute the covariance matrix $\Sigma ^T \Sigma$ at each point.
```python
def Sigma(sde, xs, ts=torch.tensor([0.0])):
    # ts should be of shape (n_sample, )
    if xs.dim() == 1:
        xs = xs.unsqueeze(-1)
    assert xs.dim() == 2
    if isinstance(ts, float):
        ts = torch.tensor([ts])
    if ts.dim() == 0:
        ts = ts.unsqueeze(0)
    if ts.dim() == 1:
        with torch.no_grad():
            sigma = _evaluate_sde_component(sde, ts, xs, component='g').squeeze(0)
            # evaluate sigma^T matmul sigma, i.e., the covariance matrix
            return torch.matmul(sigma.transpose(1, 2), sigma)
    else:
        with torch.no_grad():
            sigma = _evaluate_sde_component(sde, ts, xs, component='g')
            # evaluate sigma^T matmul sigma
            return torch.matmul(sigma.transpose(1, 2), sigma)

def rel_err_Sigma(neuralsde, sde, u_truth, ts):
    """
    Compute the relative error between the estimated diffusion from neuralsde and the true diffusion from sde for each trajectory sample.
    """
    with torch.no_grad():
        t_size, sample_size, n = u_truth.shape
        max_sample_size = 200
        if sample_size > max_sample_size:
            sample_size = max_sample_size
            u_truth = u_truth[:,:max_sample_size,:]
        squared_errors = []
        squared_norms_g = []
        for idx, t in enumerate(ts):
            # Extract the trajectory samples corresponding to the current time t
            u_truth_at_t = u_truth[idx]
            
            # Compute the estimated diffusion component for this set of trajectory samples
            g_hat_vals_at_t = Sigma(neuralsde, u_truth_at_t, t)
            
            # Compute the true diffusion component for this set of trajectory samples
            g_vals_at_t = Sigma(sde, u_truth_at_t, t)
            
            # Compute the squared error for this set of trajectory samples
            squared_error_at_t = torch.norm(g_hat_vals_at_t - g_vals_at_t, dim=-1)**2
            squared_errors.append(squared_error_at_t)
            
            # Compute the squared magnitude of the true diffusion component for this set of trajectory samples
            squared_norm_g_at_t = torch.norm(g_vals_at_t, dim=-1)**2
            squared_norms_g.append(squared_norm_g_at_t)

        # Aggregate the squared errors and norms from all time points
        total_squared_error = torch.sum(torch.cat(squared_errors))
        total_squared_norm_g = torch.sum(torch.cat(squared_norms_g))

        # Compute the relative error
        rel_error = total_squared_error / total_squared_norm_g

        return torch.sqrt(rel_error).detach().numpy()
```

- W2 Loss: `mse_f=0.10665981045556995, mse_σ=1.348218025318748`  ![[example2d_nsde_base_truth_base_W2_repeat_1_n_iter_1000.png]]
- Rotating W2 Loss (Number of Rotations = 9): `mse_f=0.12366526723585156, mse_σ=0.23972567910944234` ![[example2d_nsde_base_truth_base_W2_rotated_repeat_1_n_iter_1000.png]]
- MMD Loss: `mse_f=0.004937978688655415, mse_σ=1.0352001247374745` ![[example2d_nsde_base_truth_base_MMD_repeat_1_n_iter_1000.png]]

