
# Trans-LoRA

We propose Trans-LoRA, an approach capable of data-free LoRA model transfer between different base models (and even supporting transfer between different PEFT configurations) without requiring access to original task data. Trans-LoRA achieves equivalent or better performance when compared with the source LoRAs and the target base model. To our knowledge, this paper is the first to explore the very practical use case of transferability of PEFT models.

`train.py` contains all training and evaluation code, and `synthesis.py` contains all data synthesis code (both with and without filtering). See python files for specific supported arguments with explanations. Make sure to replace all paths and directories with yours before launching.

## Example Usage

### BBH, MMLU, & GSM8K
For an example transfer from Gemma 2b to Gemma 7b on boolean expressions task from BBH (train and evaluation both included), run:

`python train.py --basemodel gemma7b --teacher_bm gemma2b --prompting inst --lorasource YOUR_LORA_DIRECTORY --distill --lst no --data bbh --synth YOUR_SYNTHETIC_DATA --do_train --do_eval --lmeval --num_fewshot 0 --evalmode strcomp --task_name boolean_expressions --num_train_epochs 20 --max_samples 1000 --eval_accumulation_steps 8 --per_device_train_batch_size 1 --per_device_eval_batch_size 4 --gradient_accumulation_steps 8 --learning_rate 2e-05 --max_seq_length 512 --output_dir YOUR_OUTPUT_DIR"`

Replace `task_name` and `data` to switch to BBH, MMLU, or GSM8K.

### MBPP

For MBPP, the generated code snippets require additional sanitizing before evaluation according to EvalPlus package. First run training command similar to BBH in the previous section, then run the following additional commands for evaluation on MBPP after finetuning:

`python evalplus/evalplus/sanitize.py --samples DIR_TO_SAMPLES; python evalplus/evalplus/evaluate.py --dataset mbpp --samples DIR_TO_SANITIZED_SAMPLES`

### Synthesis

To generate synthetic samples, adjust the inner configurations inside `synthesis.py` and then run:

`python synthesis.py --key 0 --key2 0`

`key` stands for the task id and `key2` is designed for parallel synthesis with multiple GPUs. More specifically, switch the generation function to `gen_incontext` for BBH and MMLU, `gen_mbpp` for MBPP, and `gen_gsm` for GSM8K. Then adjust the call to generator model based on which model you would like to synthesize from (e.g. `genoutput` for Llama-2-13b and `genoutputgemma7b` for Gemma-7b). Next, decide to use discriminator or not by setting `True` or `False` in the `verify` line. Note that different models have different output format and thus the truncation on output also needs to be adjusted accordingly. Finally, run and observe data being generated!