# AMSC: Adaptive Multi-Dimensional Structured Compression with Theoretical Guarantees


This is a Pytorch implementation of paper "AMSC: Adaptive Multi-Dimensional Structured Compression with Theoretical Guarantees".

Our code is based on [ResNet_on_CIFAR10](https://github.com/akamaster/pytorch_resnet_cifar10) implementations. We thank their awesome works.


## Install

`pip install -r requirements.txt`


## Data Preparation
Please download [CIFAR-10/100](https://www.cs.toronto.edu/~kriz/cifar.html) to ./data

## Start Training

To run baseline model, initial training and retraining of AMSC on CIFAR-10,

(1) Training baseline model

`python -u trainer.py --arch=resnet56 --save-dir=./results_resnet/save_resnet56`

We also provide resnet56, resnet110, resnet164, resnet26(4x), resnet32(4x) and resnet38(4x).

(2) Initial training phase

(i) Extrate the depth weights of the baseline model

`python get_weights_of_adagouplasso.py`

(ii) Training AMSC based on the weights of baseline 

`python -u trainer_amsc.py --arch=resnet56 --save-dir=./results_resnet_amsc/save_resnet56 --dp=1e-3 --wp 1e-6 --seed 2024 --mode ladder2 --gpu 0 --baseline ./results_resnet/save_resnet56/checkpoint.th`


(3) Retraining

`python -u trainer_amsc_retrain.py --arch=resnet56 --retrain ./results_resnet_amsc/save_resnet56/dp_0.001000_wp_0.000001_seed_2024_mode_ladder2/checkpoint.th --lr 1e-1 --epochs 100 --gpu 0`


