# Decision Transformer Network

This is the code repository of *Generalizing Tree Models for Improving Prediction Accuracy*, submitted to ICLR 2021. The
repository is designed to reproduce the main results of paper.

## Requirements

This is written by Python 3.7 with the requirements listed in `requirements.txt`. A GPU environment is strongly
recommended for efficient training and inference of our models. You can type the following command to install the
required packages:
```
pip install -r requirements.txt
``` 

## Datasets

Our experiments use 121 datasets from the UCI repository. Since the size of all datasets is larger than 500MB, we
include only `balance-scale` in the current repository, which is a sample dataset that includes 625 examples of 4
features and 3 labels. You can download all the UCI datasets by running the following command:
```
cd data; bash uci.sh
```

## Demo Script

You can test our DTN-S on the `balance-scale` dataset by running the following command in the `src` directory. It is
possible to test DTN-D, change the dataset, or give other options such as the number of units in each layer.
```
python uci.py --data balance-scale
```

## Experiments

If the demo code runs successfully, you can reproduce the main results for all of the 121 UCI datasets. You should first
download the datasets (refer to the Datasets section). Then, you can run the following command:
```
python uci.py
```

It trains DTN-S for all datasets with five random seeds, creates `out/DTN-S-16/uci`, and stores the results as follows:
- `accuracy.tsv`: The average and standard deviation of accuracy for each dataset.
- `summary.tsv`: The summary of results for all datasets and random seeds.
- `logs-{SEED}`: The detailed training process for each dataset and random seed. 
