#!/usr/bin/env python
# -*-coding:utf-8 -*-
import torch 
import random 
import numpy as np 
import os 
import matplotlib.pyplot as plt 
import pickle 
import utils.vis_utils as vu
import shutil 


def seed_everything(seed):
    random.seed(seed)
    os.environ['PYTHONHASHSEED'] = str(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = True
    
    
def create_dir(path):
    if not os.path.exists(path):
        os.makedirs(path)
        

def create_single_dir(path):
    if not os.path.exists(path):
        os.mkdir(path)
        

def get_dir_name(conf):
    dir_name = "non_iid_alpha_%.3f_lr_%.3f_version_%d_%s_n_clients_%d_load_%s_%s_ratio_%d_add_fake_until_rounds_%d_arch_%s_simu_tr_%d_gen_%d" % (
        conf.non_iid_alpha, conf.lr, conf.version, conf.dataset, conf.n_clients, conf.load_opt, 
        conf.align_data, conf.fake_ratio, conf.round_to_add_fake_data, conf.arch, 
        conf.num_images_train_synthetic, conf.num_synthetic_images)
    if conf.synthetic_epoch != 500:
        dir_name += "_synthetic_epoch_%d" % conf.synthetic_epoch 
    if conf.sample_ratio != 1.0:
        dir_name += "_sample_%.2f" % conf.sample_ratio
    folder_name = "data_align_%s" %  conf.aggregation
    conf.folder_name = folder_name 
    conf.dir_name = dir_name
    return conf    



def get_replace_for_init_path(loc):
    rep = "../"
    return rep 


def get_path_init(loc):
    return "../exp_data/"


def select_random_clients(num_clients, ratio, model_dir):
    if len([v for v in os.listdir(model_dir) if "client_id" in v]) == 0:
        num_select = int(num_clients * ratio)
        select_clients = sorted(np.random.choice(np.arange(num_clients), num_select, replace=False))
        for v in select_clients:
            create_single_dir(model_dir + "/client_id_%02d/" % v)
    else:
        select_clients = sorted([int(v.split("client_id_")[1]) for v in os.listdir(model_dir) if "client_id" in v])
    return select_clients    



    
