import argparse


def str2bool(v):
    if isinstance(v, bool):
        return v
    if v.lower() in ('yes', 'true', 't', 'y', '1'):
        return True
    elif v.lower() in ('no', 'false', 'f', 'n', '0'):
        return False
    else:
        raise argparse.ArgumentTypeError('Boolean value expected.')


def give_fed_args():
    parser = argparse.ArgumentParser(description='FL')
    parser.add_argument('--dataset', type=str, default="Shape")
    parser.add_argument("--num_class", default=18, type=int)

    parser.add_argument("--arch", default="fc", type=str)
    parser.add_argument("--input", default="latent", type=str)
    parser.add_argument("--sample_ratio", default=1.0, type=float)
    
    parser.add_argument("--val_data_ratio", default=0.1, type=float)
    parser.add_argument("--train_data_ratio", default=1.0, type=float)
    
    # parser.add_argument("--batch_size", default=256, type=int)
    parser.add_argument("--batch_size", default=128, type=int)
    
    parser.add_argument("--num_workers", default=4, type=int)    

    parser.add_argument("--optimizer_name", default="sgd", type=str)

    parser.add_argument("--momentum_factor", default=0, type=float)
    parser.add_argument("--use_nesterov", default=False, type=str2bool)
    parser.add_argument("--lr", default=0.1, type=float)
    parser.add_argument("--weight_decay", default=0.0, type=float)
        
    parser.add_argument("--local_n_epochs", default=10, type=int)
    parser.add_argument("--lr_schedule", default="constant", type=str)
    parser.add_argument("--use_local_id", default=0, type=int, help="which client am I using")
    
    parser.add_argument("--n_clients", default=10, type=int)
    parser.add_argument("--selected_clients")
    parser.add_argument("--partition_type", default="non_iid", type=str)
    parser.add_argument("--non_iid_alpha", default=100, type=float)
    parser.add_argument("--partitioned_by_user", default=False, type=str2bool)
    parser.add_argument("--seed_use", type=int, default=7)
    parser.add_argument("--communication_round", type=int, default=0)
    
    parser.add_argument("--dir_name", type=str)
    parser.add_argument("--version", type=int, default=0)
    parser.add_argument("--use_wandb", type=str2bool, default=True)
    parser.add_argument("--loc", default="nobackup", type=str)
    parser.add_argument("--random_shuffle", default=True, type=str2bool)
    
    parser.add_argument("--aggregation", default="fed_avg", type=str)
    parser.add_argument("--start_layer", default=16, type=int)
    
    parser.add_argument("--align_data", default="add_fake_image", type=str)
    parser.add_argument("--worker_for_occupy_gpu", default=False, type=str2bool)
    
    parser.add_argument("--vgg_scaling", default=None, type=int)
        
    parser.add_argument("--freeze_bn", default=False, type=str2bool)
    parser.add_argument("--freeze_bn_affine", default=False, type=str2bool)
    parser.add_argument("--group_norm_num_groups", default=2, type=int)
    
    parser.add_argument("--load_opt", default="train_im", type=str)
    parser.add_argument("--fake_ratio", type=int, default=1)
    parser.add_argument("--round_to_add_fake_data", type=int, default=40)
    
    parser.add_argument("--pn_normalize", default=True, type=str2bool)
    parser.add_argument("--apply_transform", default=True, type=str2bool)
    parser.add_argument("--num_synthetic_images", default=5000, type=int)
    parser.add_argument("--updated_local_epoch", default=10, type=int)
    parser.add_argument("--num_images_train_synthetic", default=4500, type=int)
    
    parser.add_argument("--save_gradients", default=False, type=str2bool)
    parser.add_argument("--ciplus_option", default="option_two", type=str)
    parser.add_argument("--layer_wise_correction", default=True, type=str2bool)
    parser.add_argument("--free_up_space", default=True, type=str2bool)
    
    parser.add_argument("--beta", default=0.01, type=float)
    parser.add_argument("--tt_opt", default="grad", type=str)
    parser.add_argument("--shuffle_synthetic_data", default=True, type=str2bool)
    parser.add_argument("--use_original_client_data", default="combine", type=str)
    parser.add_argument("--synthetic_version", default=2, type=int)
    parser.add_argument("--synthetic_epoch", default=500, type=int)
    parser.add_argument("--centralised", default=False, type=str2bool)
    parser.add_argument("--mu_prox", default=0.01, type=float)

    return parser.parse_args()


class PARAM:
    random_state=np.random.RandomState(7)
    seed_use = 7
    
    dataset = "dsprint"
    n_clients = 1
    val_data_ratio = 0.1
    train_data_ratio = 1.0 
    partition_type = "non_iid"
    local_n_epochs = 10 
    partitioned_by_user=False
    batch_size=64
    num_workers = 4 
    use_local_id = 1
    z_dim = 10 
    
    num_class = 18 
    num_hidden = 1
    aggregation = "fed_avg"
    
    apply_transform=True 
    pn_normalize=True

