import os
import argparse


def get_sp(log_file):
    findtxt1 = 'algorithm: '
    findtxt2 = 'dataset: '
    findtxt3 = 'test_envs: '
    findtxt4 = 'train_envs: '
    findtxt5 = 'step_time'
    # findtxt4 = 'Noise: '
    # findtxt5 = 'Hessian: '
    # findtxt6 = 'ParaNorm: '
    
    m1 = len(findtxt1)
    m2 = len(findtxt2)
    m3 = len(findtxt3)
    m4 = len(findtxt4)
    # m5 = len(findtxt5)
    # m6 = len(findtxt6)
    
    alg = ' '
    ds = ' '
    start_eva, best_in, eva_out = 0, 0, 0
    
    with open(log_file, "r", encoding='utf-8') as f:
        lines=f.readlines()        
        for line in lines:
            if line != '\n':
                txt = str(line)
                # if txt.find("norm") != -1:
                    # break
                if txt.find(findtxt1) != -1:
                    target = txt[txt.find(findtxt1)+m1:]
                    value = [s for s in target.strip('\n').split(' ')]
                    alg = value[0]
                    continue
                elif txt.find(findtxt2) != -1:
                    target = txt[txt.find(findtxt2)+m2:]
                    value = [s for s in target.strip('\n').split(' ')]
                    ds = value[0]
                    continue
                elif txt.find(findtxt3) != -1:
                    target = txt[txt.find(findtxt3)+m3:]
                    value = [s for s in target.strip('\n').split(' ')]
                    ts = value[0]
                    continue
                elif txt.find(findtxt4) != -1:
                    target = txt[txt.find(findtxt4)+m4:]
                    value = [s for s in target.strip('\n').split(' ')]
                    tr = value[0]
                    continue
                elif txt.find(findtxt5) != -1:
                    start_eva = 1
                    continue
                elif start_eva>0:
                    value = [s for s in txt.split('  ')]
                    eva_in = float(value[1])
                    # print(eva_in)
                    # print(value)
                    if eva_in >= best_in:
                        best_in = eva_in
                        eva_out = float(value[2])
                    continue
                else:
                    continue
    # print(eva_out)
    return alg, ds, ts, tr, best_in, eva_out

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument('--log_dir', '-l', type=str, required=True)
    parser.add_argument('--output', '-o', type=str, default='collect_results')
    
    args = parser.parse_args()
    
    file_name = os.path.basename(args.log_dir)
    
    out_file = args.output+'.txt'
    check = os.path.exists(out_file)
    if check:
      check = os.path.getsize(out_file)
    alg, ds, ts, tr, best_in, eva_out = get_sp(args.log_dir)
    alg_space = (len('Algorithm')-len(alg))*' '
    fo = open(out_file, 'a', encoding="utf8")
    if not check:
        fo.write('Algorithm'+'   '+'Dataset'+'     '+'TrE'+'  '+'TsE'+'  '+'UDA_ACC'+'   '+'File Name')
    fo.write('\n')
    fo.write(alg+alg_space+'   '+ds+'     '+tr+'  '+ts+'  '+'%.5f'%eva_out+'   '+file_name)
    
    fo.close()
    
if __name__ == '__main__':
    main()