from setuptools import setup
from torch.utils.cpp_extension import BuildExtension, CUDAExtension

setup(
        name='fused',
        ext_modules=[
            CUDAExtension(
                    name='fused',
                    sources=["fused_bias_act.cpp", "fused_bias_act_kernel.cu"],
                    extra_compile_args={'cxx': ['-g'],
                                        'nvcc': ['-O2']})
        ],
        cmdclass={
            'build_ext': BuildExtension
        })