from setuptools import setup
from torch.utils.cpp_extension import BuildExtension, CUDAExtension

setup(
        name='upfirdn2d_op',
        ext_modules=[
            CUDAExtension(
                name= "upfirdn2d_op",
                sources=[ "upfirdn2d.cpp",  "upfirdn2d_kernel.cu"],
                extra_compile_args={'cxx': ['-g'],
                                        'nvcc': ['-O2']})
        ],
        cmdclass={
            'build_ext': BuildExtension
        })