#!/usr/bin/env bash

#cd $(dirname $0)

# first, setup the custom operators
cd models/op
python setup_fused.py install
python setup_upfirdn.py install

# train with single GPU
# on 256 data
python3 train.py --path path/to/image/folder --name experiment-name --size 256 --batch 8 --augment --crop_aug --dislow 3 --dishigh 6 --vq_emb 6 6 6 --vq_type 0 --iter 100
# on 512 or 1024 data
python3 train.py --path path/to/image/folder --name experiment-name --size 512 --ckpt_256 path/to/256-model --batch 4 \
--augment --crop_aug --dislow 3 --dishigh 6 --vq_emb 6 6 6 --vq_type 0 --iter 100

# train with multi-GPU
# on 256 data
CUDA_VISIBLE_DEVICES=0,1,2,3 python3 -m torch.distributed.launch --nproc_per_node=4 \
--master_port=23456 train.py --path ./afhq/train --name afhq_256_1 --size 256\
 --batch 8 --augment --crop_aug --dislow 2 --dishigh 5 --vq_emb 6 6 6 --vq_type 6 \
 --iter 100000
# on 512 or 1024 data
CUDA_VISIBLE_DEVICES=0,1,2,3 python3 -m torch.distributed.launch --nproc_per_node=8 --master_port=12345 \
train.py --path ./afhq/train --name afhq_512 --size 512 --ckpt_256 experiments/afhq_256_1/checkpoint/030000.pt --batch 4 \
--augment --crop_aug --dislow 2 --dishigh 7 --vq_emb 6 6 6 6 6 --vq_type 6 --iter 100000

# run benchmarks including FID, PPL and LPIPS
python3 metrics.py --path path/to/data --ckpt path/to/model --n_sample 1000 --size 256
