import argparse

parser = argparse.ArgumentParser(description="PIVQGAN Image2Image Pose/Identity Disentangle trainer")

parser.add_argument("--path",     type=str, help="path to the image folder dataset")
parser.add_argument('--name',     type=str, default='test1')
parser.add_argument('--arch',     type=str, default='stylegan2', help='model architectures (stylegan2 | swagan)')
parser.add_argument("--iter",     type=int, default=40000, help="total training iterations")
parser.add_argument("--batch",    type=int, default=8, help="batch sizes for each gpus")
parser.add_argument("--size",     type=int, default=256, help="image sizes for the model")
parser.add_argument("--ckpt",     type=str, default=None, help="path to the checkpoints to resume training")
parser.add_argument("--ckpt_256", type=str, default=None, help="path to the checkpoints to load 256 res model, used only for HR training on 512 and 1024 resolution")
parser.add_argument("--lr",       type=float, default=0.002, help="learning rate")
parser.add_argument("--channel_multiplier", type=int, default=2, help="channel multiplier factor for the model. config-f = 2, else = 1")
parser.add_argument("--rec_factor", type=int, default=2, help="divide factor of the target image for reconstruction training")
parser.add_argument("--dislow", type=int, default=3, help="conv-layer index, e.g. 8-2 -> 2, 16-1 -> 3")
parser.add_argument("--dishigh", type=int, default=6, help="conv-layer index, e.g. 8-2 -> 2, 16-1 -> 3")
parser.add_argument("--vq_emb", type=int, nargs='+', default=6, help="can be a list, with space between multiple values, conv-layer index, e.g. 8-2 -> 2, 16-1 -> 3")
parser.add_argument("--vq_type", type=int, default=0, help="different vq module structure, choose from [0,3,6]")
parser.add_argument("--crop_aug", action="store_true", help="crop a portion of the image during training")
parser.add_argument("--augment", action="store_true", help="apply non leaking augmentation on both G images and real images")

parser.add_argument("--r1",     type=float, default=10, help="weight of the r1 regularization")
parser.add_argument("--path_regularize", type=float, default=2, help="weight of the path length regularization")
parser.add_argument("--path_batch_shrink", type=int, default=2, help="batch size reducing factor for the path length regularization (reduce memory consumption)")
parser.add_argument("--d_reg_every", type=int, default=16, help="interval of the applying r1 regularization")
parser.add_argument("--g_reg_every", type=int, default=4, help="interval of the applying path length regularization")
parser.add_argument("--mixing", type=float, default=0.9, help="probability of latent code mixing")

parser.add_argument("--n_gpu", type=int, default=1, help="number of gpu to use")
parser.add_argument("--local_rank", type=int, default=0, help="local rank for distributed training")
parser.add_argument("--augment_p", type=float, default=0, help="probability of applying augmentation. 0 = use adaptive augmentation")
parser.add_argument("--ada_target", type=float, default=0.6, help="target augmentation probability for adaptive augmentation")
parser.add_argument("--ada_length", type=int, default=500 * 1000, help="target duraing to reach augmentation probability for adaptive augmentation")
parser.add_argument("--ada_every", type=int, default=256, help="probability update interval of the adaptive augmentation")
