# Test-time Aggregation for Collaborative Filtering

The paper proposes TAG-CF which is a test-time aggregation framework that can be utilized as a plug-and-play module to enhance the performance of matrix factorization models. 

## 1. Installation

Please install all dependencies using the command:
```
conda create --name <env> --file requirements.txt
```

## 2. Download data

Please download the Movielens-1M data following the [instruction](./dataset/README.md).

## 3. Run experiments

```
# Train a basic matrix factorization model
make run_pipeline MODEL_YAML_PATH=config/MF.yaml

# Train a LightGCN model. 
make run_pipeline MODEL_YAML_PATH=config/LGCN.yaml

# Conduct test-time aggregation on matrix factorization model.
make run_pipeline MODEL_YAML_PATH=config/TAGCF.yaml
```