#!/bin/bash

# ==================== main.py commands ====================
# cora
python main.py --dataset cora --lr 0.001 --wd 0.0001 --h_dim 128 --layers 3 --n_head 2 --dropout 0.5 --attn_dropout 0.3 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 128 --use_res --epochs 200 --runs 5 --display_step 100 --split random --device 0

# pubmed
python main.py --dataset pubmed --lr 5e-3 --wd 5e-3 --h_dim 128 --layers 3 --n_head 1 --dropout 0.3 --attn_dropout 0.5 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 224 --use_res --epochs 300 --runs 5 --display_step 100 --split random --device 0

# citeseer
python main.py --dataset citeseer --lr 0.001 --wd 0.0001 --h_dim 128 --layers 2 --n_head 4 --dropout 0.7 --attn_dropout 0.3 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 192 --use_res --epochs 200 --runs 5 --display_step 100 --split random --device 0

# amazon-computer
python main.py --dataset amazon-computer --lr 0.001 --wd 5e-5 --h_dim 64 --layers 5 --n_head 4 --dropout 0.3 --attn_dropout 0.3 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 224 --use_res --epochs 500 --runs 5 --display_step 100 --split random --device 0

# amazon-photo
python main.py --dataset amazon-photo --lr 0.001 --wd 1e-5 --h_dim 64 --layers 2 --n_head 1 --dropout 0.3 --attn_dropout 0.5 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 160 --use_res --epochs 300 --runs 5 --display_step 100 --split random --device 0

# squirrel
python main.py --dataset squirrel --lr 1e-3 --wd 5e-3 --h_dim 256 --layers 7 --n_head 4 --dropout 0.3 --attn_dropout 0.3 --norm_type rms --norm_pos pre --local_type GCN --num_clusters 96 --use_res --epochs 100 --runs 5 --display_step 100 --split random --device 0

# chameleon
python main.py --dataset chameleon --lr 0.001 --wd 0.005 --h_dim 256 --layers 3 --n_head 2 --dropout 0.3 --attn_dropout 0.1 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 32 --use_res --epochs 200 --runs 5 --display_step 100 --split random --device 0

# minesweeper
python main.py --dataset minesweeper --lr 0.005 --wd 0. --h_dim 64 --layers 15 --n_head 8 --dropout 0.3 --attn_dropout 0. --norm_type rms --norm_pos pre --local_type GAT --num_clusters 192 --use_res --epochs 2000 --runs 5 --display_step 100 --metric rocauc --split random --device 0

# ogbn-arxiv
python main.py --dataset ogbn-arxiv --layers 5 --n_head 1 --num_clusters 2048 --lr 5e-4 --wd 5e-4 --dropout 0.5 --attn_dropout 0.5 --semi --split fixed --epochs 2000 --runs 5 --h_dim 256 --use_res --use_cache --local_type GCN --norm_type bn --norm_pos post --device 0


# ==================== eval.py commands ====================
# cora
python eval.py --dataset cora --lr 0.001 --wd 0.0001 --h_dim 128 --layers 3 --n_head 2 --dropout 0.5 --attn_dropout 0.3 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 128 --use_res --epochs 200 --runs 5 --display_step 100 --split random --device 0

# citeseer
python eval.py --dataset citeseer --lr 0.001 --wd 0.0001 --h_dim 128 --layers 2 --n_head 4 --dropout 0.7 --attn_dropout 0.3 --norm_type rms --norm_pos pre --local_type GAT --num_clusters 192 --use_res --epochs 200 --runs 5 --display_step 100 --split random --device 0