# Reproduce Instructions

## Environment Setup

```shell
# create dusa environment
conda create -n dusa -y python=3.9.18
conda activate dusa
# install torch
pip install torch==2.1.2 torchvision==0.16.2 torchaudio==2.1.2 --index-url https://download.pytorch.org/whl/cu121
# install open-mmlab
pip install openmim==0.3.9
mim install "mmcv==2.1.0"
mim install "mmengine==0.10.2"
# install others
conda env update -n dusa -f env.yml
```

## Prepare Models

Access pre-trained weights from the following resources:

+ [`ResNet50`](https://github.com/rwightman/pytorch-image-models/releases/download/v0.1-rsb-weights/resnet50_gn_a1h2-8fe6c4d0.pth)
+ [`ViT-B/16`](https://storage.googleapis.com/vit_models/augreg/B_16-i1k-300ep-lr_0.001-aug_strong2-wd_0.1-do_0.1-sd_0.1--imagenet2012-steps_20k-lr_0.01-res_224.npz)
+ [`ConvNeXt-L`](https://download.openmmlab.com/mmclassification/v0/convnext/convnext-large_3rdparty_64xb64_in1k_20220124-f8a0ded0.pth)
+ [`DiT-XL`](https://dl.fbaipublicfiles.com/DiT/models/DiT-XL-2-256x256.pt)
  + [`stabilityai/sd-vae-ft-ema`](https://huggingface.co/stabilityai/sd-vae-ft-ema) is automatically downloaded

Download weights and place them in the `./pretrained_models` directory.

## Prepare Data

The ImageNet-C can be downloaded from the following links: 

[Download ImageNet-C here. (Mirror.)](https://zenodo.org/record/2235448)

Download the dataset and extract it to the `./data/imagenet-c` directory.

## Run Experiments

The scripts are available in the `./sh` directory.

### ConvNeXt-L

+ Baselines
  ```shell
  bash sh/baseline/main/baselines_convnext_in-c.sh
  ```
+ DUSA
  ```shell
  bash sh/ours/dusa_main/ours_bs64_convnext_in-c.sh
  ```
+ DUSA-U
  ```shell
  bash sh/ours/dusa_uncond/ours_bs64_uncond_convnext_in-c.sh
  ```
+ Ablation on Noise
  ```shell
  bash sh/ours/dusa_ablation/ours_ablation_convnext.sh
  ```

### ConvNeXt-L for Continual TTA
+ Baselines
  ```shell
  bash sh/baseline/continual/baselines_continual_convnext_in-c.sh
  ```
+ DUSA
  ```shell
    bash sh/ours/dusa_continual/ours_continual_convnext_in-c.sh
    ```

### ViT-B/16

+ Baselines
  ```shell
  bash sh/baseline/main/baselines_vit_in-c.sh
  ```
+ DUSA
  ```shell
  bash sh/ours/dusa_main/ours_bs64_vit_in-c.sh
  ```
+ DUSA-U
  ```shell
    bash sh/ours/dusa_uncond/ours_bs64_uncond_vit_in-c.sh
  ```

### ResNet50

+ Baselines
    ```shell
    bash sh/baseline/main/baselines_res50_gn_in-c.sh
    ```
+ DUSA
    ```shell
    bash sh/ours/dusa_main/ours_bs64_res50_gn_in-c.sh
    ```
+ DUSA-U
    ```shell
    bash sh/ours/dusa_uncond/ours_bs64_uncond_res50_in-c.sh
    ```
+ Ablation on Noise
    ```shell
    bash sh/ours/dusa_ablation/ours_ablation_res50.sh
    ```

