#!/bin/bash
task_list=("motion_blur/5" "snow/5" "fog/5" "shot_noise/5"  "contrast/5" "zoom_blur/5" "brightness/5" "frost/5" "elastic_transform/5" "glass_blur/5" "gaussian_noise/5" "pixelate/5" "jpeg_compression/5" "impulse_noise/5")

for task in "${task_list[@]}"
do
    CUDA_VISIBLE_DEVICES=0 \
    WANDB_MODE=offline \
    python main.py +experiment=dit \
    model.class_arch=resnet50_gn \
    model.checkpoint_path='pretrained_models/resnet50_gn_a1h2-8fe6c4d0.pth' \
    model.zoo="timm" \
    input.batch_size=3 \
    tta.gradient_descent.accum_iter=2 \
    tta.gradient_descent.train_steps=1 \
    input.dataset_name=ImageNetCDataset \
    tta.gradient_descent.accum_batch_size=64 \
    tta.gradient_descent.base_learning_rate=1e-5 \
    tta.gradient_descent.optimizer=adam \
    tta.gradient_descent.optimizer_momentum=0.9 \
    tta.online=True \
    input.subsample=null \
    input.split="$task" \
    input.shuffle=True \
    log_freq=50000 \
    log_path="./outputs/resnet50_gn" \
    hydra.run.dir="./outputs/resnet50_gn/$task"
done