#!/bin/bash
now=$(date +"%Y-%m-%d_%H-%M-%S.%N")
task_list=("gaussian_noise/5" "shot_noise/5" "impulse_noise/5" "defocus_blur/5" "glass_blur/5" "motion_blur/5" "zoom_blur/5" "snow/5" "frost/5" "fog/5" "brightness/5" "contrast/5" "elastic_transform/5" "pixelate/5" "jpeg_compression/5")

for task in "${task_list[@]}"
do
  # judge if is the first task
  if [ "$task" == "gaussian_noise/5" ]; then
    CUDA_VISIBLE_DEVICES=0 \
    WANDB_MODE=offline \
    python main.py +experiment=dit \
    model.class_arch=convnext_large \
    model.checkpoint_path='pretrained_models/convnext_large_1k_224_ema.pth' \
    model.zoo="timm" \
    input.batch_size=3 \
    tta.gradient_descent.accum_iter=2 \
    tta.gradient_descent.train_steps=1 \
    tta.gradient_descent.accum_batch_size=64 \
    input.dataset_name=ImageNetCDataset \
    tta.gradient_descent.base_learning_rate=1e-5 \
    tta.gradient_descent.optimizer=adam \
    tta.gradient_descent.optimizer_momentum=0.9 \
    tta.online=True \
    continual.is_ckpt_continual=True \
    continual.is_first_task=True \
    continual.tta_model_ckpt_path="./outputs/tta_model_ckpt_path.pth" \
    continual.optimizer_ckpt_path="./outputs/optimizer_ckpt_path.pth" \
    input.subsample=null \
    input.split="$task" \
    input.shuffle=True \
    log_freq=50000 \
    log_path="./outputs/convnext_large/continual" \
    hydra.run.dir="./outputs/convnext_large/continual/$task"
  else
    CUDA_VISIBLE_DEVICES=0 \
    WANDB_MODE=offline \
    python main.py +experiment=dit \
    model.class_arch=convnext_large \
    model.checkpoint_path='pretrained_models/convnext_large_1k_224_ema.pth' \
    model.zoo="timm" \
    input.batch_size=3 \
    tta.gradient_descent.accum_iter=2 \
    tta.gradient_descent.train_steps=1 \
    tta.gradient_descent.accum_batch_size=64 \
    input.dataset_name=ImageNetCDataset \
    tta.gradient_descent.base_learning_rate=1e-5 \
    tta.gradient_descent.optimizer=adam \
    tta.gradient_descent.optimizer_momentum=0.9 \
    tta.online=True \
    continual.is_ckpt_continual=True \
    continual.is_first_task=False \
    continual.tta_model_ckpt_path="./outputs/tta_model_ckpt_path.pth" \
    continual.optimizer_ckpt_path="./outputs/optimizer_ckpt_path.pth" \
    input.subsample=null \
    input.split="$task" \
    input.shuffle=True \
    log_freq=50000 \
    log_path="./outputs/convnext_large/continual" \
    hydra.run.dir="./outputs/convnext_large/continual/$task"
  fi
done