# Unsupervised learning of features and object boundaries from local prediction
This is the supplementary material to our NeurIPS 2022 submission with the
title above. We enclose anonymized code that implements the DNN training,
results for all network versions, and the evaluation on BSDS500. Furthermore
we include a 'supplement.pdf' file which contains more detailed information
on the exact training parameters we used to produce the results in the
manuscript. Below you find sections for each top-level file and folder
within this supplement with a short description of the content and how to use it.

## Workflow
There are three steps to training and evaluating one of our models.

First, the model needs to be trained on unlabeled natural images. This step
takes the most time and using a GPU is strongly recommended. The code to
perform this step is in the predseg folder.

Second, the segmentations for the BSDS500 need to be computed and saved.
This step runs primarily on CPU and is implemented in python in the predseg
folder, too.

Third, the evaluation code from the BSDS500 benchmark needs to be run.
This step is implemented in the matlab folder, runs exclusively on CPU
and should be relatively quick.


## Requirements
To run this code you need the MS COCO unlabeled images (or any other set of
training images), the BSDS500 images for evaluation, a few python packages
(listed in predseg/requirements.txt) and MATLAB for running the evaluation code for BSDS500.
Furthermore, a GPU or a lot of time are required for training the networks.

The MS COCO unlabeled images are available here:
https://cocodataset.org/#download
http://images.cocodataset.org/zips/unlabeled2017.zip

The BSDS500 dataset is available here:
http://www.eecs.berkeley.edu/Research/Projects/CS/vision/grouping/BSR/BSR_bsds500.tgz

## predseg
This folder contains the code we used for training and evaluating the models.
To run the code, pip install the packages in requirements.txt and fill in
where you saved the training images and BSDS500, and where you want to save
the models and their output.

With this setup in place you should be able to run the script_* files.
These are set up such that python script_* --help will return usage information.

### script_general
This script allows you to set all parameters of training or evaluation
manually by passing the corresponding arguments.

### script_list
This script runs the chosen action with options predefined in models.json.
0-23 are the pixel models
24-47 are the linear models
48-71 are the predseg1 models

### script_show_models
This script just displays the saved models and their configurations

## matlab
This folder contains the evaluation code for the BSDS500 dataset for your
convenience. The main function to run is:
bench_bsds500([model], [version], ['/path/to/BSDS500'], 'train', 'quant')

Which evaluates the outputs of a model version on the training set.

## model_output
In this folder we supply the segmentations produced by the highest performing
models we report in the paper. Due to size limitations, we cannot provide the
segmentations by the other instances. Their evaluations are available in the
.csv files in the matlab folder though.

For our main evaluation we saved the segmentations in .mat format to avoid
the rounding effects of using gray scale images. The .png files are smaller
and more convenient to look at though.

## models
Here we provide the hyper-parameters and parameters for the best models.

## Supplement.pdf
Additional appendix text specifying our training regime in more detail.

## w_maps
Here, we show the inferred w_maps for the example images from the paper. These are provided primarily to show that the inferred w_maps are sensible without the application of the globalization method.

The file with just a number as a name shows the image, the sum of the log-posterior ratios for the $w$s and the contours inferred from the globalization algorithm. The file with the w_maps addition, shows the log posteriors separately for the different neighborhood relationships.
