function result = summarize_BSD(model, BSD_dir, split, transform, subset)

if ~exist('BSD_dir', 'var') || isempty(BSD_dir)
    BSD_dir = '~/predseg/BSDS500/';
end
if ~exist('split', 'var') || isempty(split)
    split = 'train';
end
if ~exist('transform', 'var') || isempty(transform)
    transform = 'quant';
end
if ~exist('subset', 'var') || isempty(subset)
    subset = false;
end

versions = dir(fullfile(BSD_dir, 'model_output', model));
versions = versions(~ismember({versions.name} ,{'.','..','.DS_store'}));

result = nan(length(versions), 9); 
for i = 1:length(versions)
    if subset
        outfile = fullfile(BSD_dir, 'model_output', model, ...
            versions(i).name, sprintf('%s_%s_eval', split, transform), subset, 'eval_bdry.txt');
    else
        outfile = fullfile(BSD_dir, 'model_output', model, ...
            versions(i).name, sprintf('%s_%s_eval', split, transform), 'eval_bdry.txt');
    end
    result(i,1) = str2double(versions(i).name(8:end));
    if isfile(outfile)
        evalRes = dlmread(outfile);
        result(i, 2:end) = evalRes;
    end
end

result = sortrows(result, 1);
if subset
    csvwrite(sprintf('%s_%s_%s_%s.csv', model, split, transform, subset), result)
else
    csvwrite(sprintf('%s_%s_%s.csv', model, split, transform), result)
end
