# Decoupling weighing and selecting for Integrating Multiple Graph Pre-training Tasks

This is a PyTorch implementation of *Decoupling weighing and selecting for Integrating Multiple Graph Pre-training Tasks **(WAS)***

## Requirements

* torch == 1.7.0
* torchvision == 0.8.1+cu110
* pyro== 1.5.2
* torch_geometric == 2.0.4

## Description

* train.py  

  * Load_teacher_models()
    * Load the pre-trained teacher models
    * the code for pre-training can be found at './train_teachers/src', which is based on https://github.com/chao1224/GraphMVP
  * train_student_model() 
    * weigh and select teachers to transfer their combined knowledge to student model

* ./models/molecule_gnn_model.py  

  * GNN_graphpred():
    * Extension of GIN to incorporate edge information by concatenation
    * estimate_optimal_distribution()
      * to weigh and select teachers
  * pse_softmax():
    * only use the selected teachers to do softmax

* ./datasets/molecule_dataset.py  

  * provide dataloader for molecule data

* ./molecule_datasets  
  * put the datasets here


## Experiments

1. Use the code in 'train_teachers' to pre-train teachers

2. Rename teacher models as '{Pre-training task name}_model.pth' and put them to "./teachers/{downstram task name}"

3. To use the framework  **WAS**, use code as follows:


  ```python
python train.py --dataset dataset_name --m momentum_parameter
  ```

Due to the space limitation, we can't upload all datasets and pre-trained teachers. As an example, we upload the trained teachers on sider, and you can use the following code to reproduce.

  ```python
python train.py --dataset sider --m 0.5
  ```

