#!/bin/bash

PYTHONPATH=/workspace/supplementary_material/src \
python3 /workspace/supplementary_material/src/pretrain.py \
config.EXPR_NAME=test \
config.DATA_PATH=/dev/shm/movienet \
config.TRAINER.max_epochs=20 \
config.TRAIN.BATCH_SIZE.effective_batch_size=256 \
config.TEST.BATCH_SIZE.effective_batch_size=96 \
config.DISTRIBUTED.NUM_PROC_PER_NODE=8 \
config.TRAIN.NUM_WORKERS=6 \
config.TRAIN.NUM_KEYFRAME=1 \
config.MODEL.shot_encoder.name=vit_x_ge \
config.MODEL.shot_encoder.pretrained=True \
config.MODEL.shot_encoder.freeze=True \
config.MODEL.shot_encoder.vit_x_ge.weights=vit_base_patch32_clip_224 \
config.MODEL.shot_encoder.vit_x_ge.ge_path=genre_embed/genre_embed_by_defi.npy \
config.MODEL.contextual_relation_network.name=trn \
config.MODEL.contextual_relation_network.attention_mask_type=directional \
config.MODEL.contextual_relation_network.params.trn.input_dim=768 \
config.MODEL.contextual_relation_network.params.trn._attn_implementation=sdpa \
config.LOSS.shot_scene_matching.params.simclr_loss.head.input_dim=768 \
config.LOSS.shot_scene_matching.params.simclr_loss.head.hidden_dim=768 \
config.LOSS.sampling_method.use_duration=True \
config.LOSS.sampling_method.anchor_sample_type=short_weighted \
config.LOSS.sampling_method.name=asymmetric \
config.LOSS.sampling_method.params.asymmetric.neighbor_left=8 \
config.LOSS.sampling_method.params.asymmetric.neighbor_right=8