from utils.hydra_utils import print_cfg
from utils.main_utils import (
    init_hydra_config,
    apply_random_seed,
    init_data_loader,
    init_model,
    init_trainer,
    load_pretrained_config,
)
from utils.debug_utils import debug

import logging
import os


def main():

    cfg = init_hydra_config(mode="finetune")
    apply_random_seed(cfg)
    cfg = load_pretrained_config(cfg)


    cfg, trainer = init_trainer(cfg)

    cfg.FINETUNED_LOAD_FROM = os.path.join(cfg.CKPT_PATH, cfg.EXPR_NAME, "model.ckpt")
    _, best_model = init_model(cfg)

    _, test_loader = init_data_loader(cfg, mode="finetune", is_train=False, is_test=True)
    
    trainer.test(best_model, dataloaders = test_loader)
    

if __name__ == "__main__":
    main()