export PYTHONPATH=.:$PYTHONPATH
export PYTHONPATH=$PYTHONPATH:/home/zhengyao/project/transformer_planning/implicit_q_learning

datasets=(pen-cloned-v0)

name=T-3
for round in {1..5}; do
  for data in ${datasets[@]}; do
    python scripts/train.py --dataset $data --exp_name $name-$round --tag development --seed $round
    python scripts/trainprior.py --dataset $data --exp_name $name-$round
    for i in {1..20};
    do
      python scripts/plan.py --test_planner beam_prior --dataset $data --exp_name $name-$round --suffix $i --prob_threshold 0.05 --rounds 1 --nb_samples 4096 --n_expand 4 --beam_width 256 --horizon 31
    done
  done
done

for round in {1..5}; do
  python plotting/read_results.py --exp_name $name-$round --dataset $data
done

python plotting/read_results.py --exp_name $name --dataset $data

