export PYTHONPATH=.:$PYTHONPATH
export PYTHONPATH=$PYTHONPATH:/home/zhengyao/project/transformer_planning/implicit_q_learning

name=T-2
antdatasets=(antmaze-medium-play-v0 antmaze-medium-diverse-v0)

for round in {1..5}; do
  for data in ${antdatasets[@]}; do
    python scripts/train.py --dataset $data --exp_name $name-$round --tag development --seed $round
    python scripts/trainprior.py --dataset $data --exp_name $name-$round
    for i in {1..20};
    do
       python scripts/plan.py --test_planner beam_prior --dataset $data --exp_name $name-$round --suffix $i --prob_threshold 0.0 --prob_weight 0.5 --rounds 1 --nb_samples 1 --beam_width 64 --n_expand 4 --iql_value False
    done 
  done
done

for data in ${antdatasets[@]}; do
  for round in {1..5}; do
    python plotting/read_results.py --exp_name $name-$round --dataset $data
  done

  python plotting/read_results.py --exp_name $name --dataset $data 
  #> ./$name-$data-beam-04.log
done


