import numpy as np

from lamcts_planning.envs.env_utils import mountain_car_continuous_v0, swimmer_v2, lunar_lander_continuous_v2, ant_v2, hopper_v2, \
        hallway_v0, molecule

ENV_INFO = {
    'Swimmer-v2': {
        'action_dims': 2,
        'state_dims': 8,
        'lb': -7 * np.ones(2),
        'ub':  7 * np.ones(2),
        'simulate_fn': swimmer_v2.simulate,
        'restore_fn': swimmer_v2.restore,
    },
    'MountainCarContinuous-v0': {
        'action_dims': 1,
        'state_dims': -1, # TODO if using for latent space
        'lb': -1 * np.ones(1),
        'ub':  1 * np.ones(1),
        'simulate_fn': mountain_car_continuous_v0.simulate,
        'restore_fn': mountain_car_continuous_v0.restore,
    },
    'LunarLanderContinuous-v2': {
        'action_dims': 2,
        'state_dims': -1, # TODO if using for latent space
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': lunar_lander_continuous_v2.simulate,
        'restore_fn': lunar_lander_continuous_v2.restore,
    },
    'Ant-v2': {
        'action_dims': 8,
        'state_dims': -1, # TODO if using for latent space
        'lb': -5 * np.ones(8),
        'ub':  10 * np.ones(8),
        'simulate_fn': ant_v2.simulate,
        'restore_fn': ant_v2.restore,
    },
    'Hopper-v2': {
        'action_dims': 3,
        'state_dims': 11,
        'lb': -10 * np.ones(3),
        'ub':  10 * np.ones(3),
        'simulate_fn': hopper_v2.simulate,
        'restore_fn': hopper_v2.restore,
    },
    'MiniWorld-Hallway-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 250,
    },
    'MiniWorld-MazeS2-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 96,
    },
    'MiniWorld-MazeS3-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 216,
    },
    'MiniWorld-Maze-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 1536,
    },
    'MiniWorld-FourRooms-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 250,
    },
    'MiniWorld-YMaze-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 280,
    },
    'MiniWorld-TMaze-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 280,
    },
    'MiniWorld-PickupObjs-v0': {
        'action_dims': 2,
        'state_dims': 3 * 80 * 60,
        'lb': -1 * np.ones(2),
        'ub':  1 * np.ones(2),
        'simulate_fn': hallway_v0.simulate,
        'restore_fn': hallway_v0.restore,
        'env_length': 200,
    },
    'QED': {
        'action_dims': 32,
        'state_dims': 200,
        'lb': -1 * np.ones(32),
        'ub':  1 * np.ones(32),
        'simulate_fn': molecule.simulate,
        'restore_fn': molecule.restore,
        'env_length': 1,
    },
    'DRD2': {
        'action_dims': 32,
        'state_dims': 200,
        'lb': -1 * np.ones(32),
        'ub':  1 * np.ones(32),
        'simulate_fn': molecule.simulate,
        'restore_fn': molecule.restore,
        'env_length': 1,
    },
    'SARS': {
        'action_dims': 32,
        'state_dims': 200,
        'lb': -1 * np.ones(32),
        'ub':  1 * np.ones(32),
        'simulate_fn': molecule.simulate,
        'restore_fn': molecule.restore,
        'env_length': 1,
    },
    'hiv': {
        'action_dims': 32,
        'state_dims': 200,
        'lb': -1 * np.ones(32),
        'ub':  1 * np.ones(32),
        'simulate_fn': molecule.simulate,
        'restore_fn': molecule.restore,
        'env_length': 1,
    },
    'MolLength': {
        'action_dims': 32,
        'state_dims': 200,
        'lb': -1 * np.ones(32),
        'ub':  1 * np.ones(32),
        'simulate_fn': molecule.simulate,
        'restore_fn': molecule.restore,
        'env_length': 1,
    },
}
