import json
from collections import defaultdict

SYS_PROMT = {
    "role": "system",
    "content": f"Your task is to assess the quality of the translation.",
}

TEMPLATE_SRC = 'Given the translation from {source_lang} to {target_lang} and the annotated error spans, assign a score on a continuous scale from 0 to 100. The scale has following reference points: 0="No meaning preserved", 33="Some meaning preserved", 66="Most meaning preserved and few grammar mistakes", up to 100="Perfect meaning and grammar".\n\nScore the following translation from {source_lang} source:\n```{source_seg}```\n{target_lang} translation:\n```{target_seg}```\nAnnotated error spans:\n```{error_spans}```\nScore (0-100): '
TEMPLATE_GEMBA_ESA_RANKING_SRC = [SYS_PROMT, {"role": "user", "content": TEMPLATE_SRC}]

TEMPLATE_JOINT = 'Given the translation from {source_lang} to {target_lang} and the annotated error spans, assign a score on a continuous scale from 0 to 100. The scale has following reference points: 0="No meaning preserved", 33="Some meaning preserved", 66="Most meaning preserved and few grammar mistakes", up to 100="Perfect meaning and grammar".\n\nScore the following translation from {source_lang} source:\n```{source_seg}```\n{target_lang} human reference:\n```{reference_seg}```\n{target_lang} translation:\n```{target_seg}```\nAnnotated error spans:\n```{error_spans}```\nScore (0-100): '
TEMPLATE_GEMBA_ESA_RANKING_JOINT = [
    SYS_PROMT,
    {"role": "user", "content": TEMPLATE_JOINT},
]

TEMPLATE_REF = 'Given the translation from {source_lang} to {target_lang} and the annotated error spans, assign a score on a continuous scale from 0 to 100. The scale has following reference points: 0="No meaning preserved", 33="Some meaning preserved", 66="Most meaning preserved and few grammar mistakes", up to 100="Perfect meaning and grammar".\n\nScore the following translation from {target_lang} human reference:\n```{reference_seg}```\n{target_lang} translation:\n```{target_seg}```\nAnnotated error spans:\n```{error_spans}```\nScore (0-100): '
TEMPLATE_GEMBA_ESA_RANKING_REF = [SYS_PROMT, {"role": "user", "content": TEMPLATE_REF}]
