# Installation
Run `pip install -r requirements.txt` in a Python environment with Python 3.10 or above. The main dependencies are jax and tensorflow.
Update 'project_dir' in configs.py to point to the present directory. This is the "project root" directory.

# Data
Download the physics and speech data from the RD-sandwich bounds repo (https://github.com/mandt-lab/RD-sandwich/tree/master/data), and put the numpy files in data/.

# Experiments
We keep all the hyperparameter settings in python scripts in the `configs/` sub-directory of each method.
We give experiment commands below running with the default hyparameter setting. To perform hyperparameter sweeps,
loop through `hid` as follows:
    for i in {0..15}
    do
        python  -m bagd.train  --config bagd/configs/sphere.py --hid $i --experiments_dir './results' --alsologtostderr
    done

or easily launch all of them via the Slurm cluster management software (requires separate Slurm installation):
    ./launch.py --main  bagd.train --config bagd/configs/sphere.py

All commands should be run from the project root directory.

## Maximum-likelihood deconvolution
For the proposed WGD algorithm:
    python  -m bagd.train  --config bagd/configs/sphere.py --experiments_dir './results' --alsologtostderr

For the proposed hybrid WGD algorithm (using the same hyperparameter setting as WGD above):
    python  -m bahybrid.train  --config bagd/configs/sphere.py --experiments_dir './results' --alsologtostderr

For the BA algorithm:
    python  -m ba.train  --config ba/configs/sphere.py --experiments_dir './results' --alsologtostderr

For the RD-VAE algorithm:
    python  -m rdvae.train  --config rdvae/configs/sphere.py --experiments_dir './results' --alsologtostderr

For the NERD algorithm:
    python  -m nerd.train  --config nerd/configs/sphere.py --experiments_dir './results' --alsologtostderr

## R-D estimation for physics and speech data.
To handle the large number of source (\mu) samples, we experiment with methods that support stochastic optimization and SGD.
The BA and hybrid algorithms (which uses BA updates) are no longer directly applicable.

For the proposed WGD algorithm:
    python  -m bagd.train  --config bagd/configs/physics.py --experiments_dir './results' --alsologtostderr

For the NERD algorithm:
    python  -m nerd.train  --config nerd/configs/physics.py --experiments_dir './results' --alsologtostderr

Replace 'physics.py' above with 'speech.py' to run on the speech data.

The results for RD-VAE are obtained from Yang and Mandt 2022, Towards empirical sandwich bounds on the rate-distortion function.


# Copywright
All rights reserved, authors of OpenReview Submission 11613, Estimating the Rate-Distortion Function by Wasserstein Gradient Descent.

