import os.path
import random
import sys


def make_subset(base_path, subset_size, save_to=""):
    base_entries = [line.strip() for line in open(base_path, "r")]
    fout = open(save_to, "w")

    entries = random.sample(base_entries, subset_size)
    for e in entries:
        fout.write(f"{e}\n")

    fout.close()


def main(argv):
    assert len(argv) >= 4, "Insufficient number of args: {}".format(len(argv))
    base_path = str(argv[1])
    subset_size = int(argv[2])
    save_to = str(argv[3])
    make_subset(base_path, subset_size, save_to)


if __name__ == '__main__':
    main(sys.argv)
