#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import codecs
import os
import numpy as np
import glob
import argparse



def extract_files(folder_path,out_path):
    train_folder_path = os.path.join(folder_path,'train')
    dev_folder_path = os.path.join(folder_path,'validation')
    eval_folder_path = os.path.join(folder_path,'test')
    if not os.path.exists(out_path):
        os.makedirs(out_path)
    fw_train_txt = codecs.open(out_path+'/train_lfcc_sox.txt','a',encoding='utf-8')
    fw_dev_txt = codecs.open(out_path+'/validation_lfcc_sox.txt','a',encoding='utf-8')
    fw_eval_txt = codecs.open(out_path+'/test_lfcc_sox.txt','a',encoding='utf-8')

    train_lists=[]
    dev_lists = []
    eval_lists=[]
    
    for curDir,dirs,files in os.walk(train_folder_path):
        for file in files:
            train_lists.append(os.path.join(curDir,file))
    for curDir,dirs,files in os.walk(dev_folder_path):
        for file in files:
            dev_lists.append(os.path.join(curDir,file))
    for curDir,dirs,files in os.walk(eval_folder_path):
        for file in files:
            eval_lists.append(os.path.join(curDir,file))
    for train in train_lists:
        # tp_list = train.split('/')[-3:-1]
        # tp = '/'.join(tp_list)
        tp = train.split('/')[-4]
        if tp in class_ids:
            label = class_ids[tp]
        else:
            print(train)
            continue
        fw_train_txt.write(train.strip()+'\t'+str(label)+'\n')
    for dev in dev_lists:
        # tp_list = dev.split('/')[-3:-1]
        # tp = '/'.join(tp_list)
        tp = dev.split('/')[-4]
        if tp in class_ids:
            label = class_ids[tp]
        else:
            print(dev)
            continue
        fw_dev_txt.write(dev.strip()+'\t'+str(label)+'\n')
    for eval in eval_lists:
        # tp_list = eval.split('/')[-3:-1]
        # tp = '/'.join(tp_list)
        tp = eval.split('/')[-4]
        if tp in class_ids:
            label = class_ids[tp]
        else:
            print(eval)
            continue
        fw_eval_txt.write(eval.strip()+'\t'+str(label)+'\n')
    print("finish")

def extract_feat_files(folder_path,out_path):
    train_folder_path = os.path.join(folder_path,'train')
    dev_folder_path = os.path.join(folder_path,'test')
    eval_folder_path = os.path.join(folder_path,'validation')
    if not os.path.exists(out_path):
        os.makedirs(out_path)
    fw_train_txt = codecs.open(out_path+'/training_feat0308.txt','a',encoding='utf-8')
    fw_dev_txt = codecs.open(out_path+'/testing_feat0308.txt','a',encoding='utf-8')
    fw_eval_txt = codecs.open(out_path+'/validation_feat0308.txt','a',encoding='utf-8')

    train_lists=[]
    dev_lists = []
    eval_lists=[]
    
    for curDir,dirs,files in os.walk(train_folder_path):
        for file in files:
            train_lists.append(os.path.join(curDir,file))
    for curDir,dirs,files in os.walk(dev_folder_path):
        for file in files:
            dev_lists.append(os.path.join(curDir,file))
    for curDir,dirs,files in os.walk(eval_folder_path):
        for file in files:
            eval_lists.append(os.path.join(curDir,file))
    for train in train_lists:
        tp_list = train.split('/')[-3]
        print(tp_list)
        #tp = '/'.join(tp_list)
        if tp_list in class_ids:
            label = class_ids[tp]
        else:
            print(train)
            continue
        fw_train_txt.write(train+' '+str(label)+'\n')
    for dev in dev_lists:
        tp_list = dev.split('/')[-3]
        tp = '/'.join(tp_list)
        if tp in class_ids:
            label = class_ids[tp]
        else:
            print(dev)
            continue
        fw_dev_txt.write(dev+' '+str(label)+'\n')
    for eval in eval_lists:
        tp_list = eval.split('/')[-3]
        tp = '/'.join(tp_list)
        if tp in class_ids:
            label = class_ids[tp]
        else:
            print(eval)
            continue
        fw_eval_txt.write(eval+' '+str(label)+'\n')
    print("finish")
