import soundfile as sf
import numpy as np
import torch
from torch.utils.data import Dataset

from g_lfcc import linear_fbank, extract_lfcc
from utils import utils


class SpeechDataset(Dataset):
    """Speech dataset."""

    def __init__(self, manifest, mode):
        """
        Read the textfile and get the paths
        """
        self.mode = mode
        self.audio_links = [line.rstrip('\n').split('\t')[0] for line in open(manifest)]
        self.labels = [int(line.rstrip('\n').split('\t')[1]) for line in open(manifest)]

    def __len__(self):
        return len(self.audio_links)

    def __getitem__(self, idx):
        audio_link = self.audio_links[idx]
        class_id = self.labels[idx]

        spec, feat_length = utils.load_data(audio_link, mode=self.mode)

        sample = {'features': torch.from_numpy(np.ascontiguousarray(spec)),
                  'labels': torch.from_numpy(np.ascontiguousarray(class_id)),
                  'features_length': feat_length}
        return sample


class SpeechFeatureDataset(Dataset):
    """Speech dataset."""

    def __init__(self, manifest, mode):
        """
        Read the textfile and get the paths
        """
        self.mode = mode
        self.npy_files = [line.rstrip('\n').split('\t')[0] for line in open(manifest)]
        self.labels = [int(line.rstrip('\n').split('\t')[1]) for line in open(manifest)]

    def __len__(self):
        return len(self.npy_files)

    def __getitem__(self, idx):
        npy_filepath = self.npy_files[idx]
        class_id = self.labels[idx]
        spec, feature_length = utils.load_npy_data(npy_filepath, mode=self.mode)
        sample = {
            'features': torch.from_numpy(np.ascontiguousarray(spec)),
            'labels': torch.from_numpy(np.ascontiguousarray(class_id)),
            'features_length': feature_length
        }
        return sample
