function [time_values, time_std, accuracy_values, accuracy_std, A, OT1] = run_experiment(max_d, supp, db1)


    % set barycenter options
    options.max_support_size=supp;
    options.init_method='kmeans'; % {'kmeans', 'mvnrnd'}
    options.support_size=supp;
    options.max_support_size=options.support_size;
    options.method='badmm'; % {'lp', 'gd', 'badmm', 'admm', 'ibp'}
    options.badmm_tol=1e-3;
    

    


    % initilize arrays to record time and accuracy
    time_values = zeros(1, max_d-1);
    time_std = zeros(1, max_d-1);
    accuracy_values = zeros(1, max_d-1);
    accuracy_std =  zeros(1, max_d-1); 
    
    
    imgs = db1{1}.supp;
        
    % compute some kantorovich matrix
    disp('kantorovich prepare');
    max_stride = max(cellfun(@(x) max(x.stride), db1));
    A = kantorovich_prepare(supp, max_stride);
    disp('done!');
    
    n=length(db1);
    c0=cell(n,1);
    for s=1:n
        c0{s}=centroid_init(db1{s}.stride, db1{s}.supp, db1{s}.w, options);
    end
    
    tic;
    [c1, OT1, time_taken_orig]= Wasserstein_Barycenter(db1, c0, A, options);
    toc;

    [barycenter, cost_orig, old_cost_orig] = wb_processing(OT1, db1, 2, supp, 4096, c1{1}.supp'); %wb_processing(OT1, db1, 10, supp, 784, c1{1}.supp');

    tic;
    for d=2:max_d
        disp('current dimension');
        disp(d);
        disp('###');
        curr_time = zeros(1, 10);
        curr_accuracy = zeros(1, 10);
        for j=1:20
            new_imgs = dimreduction(imgs, 4096, d);
            db2 = db1;
            db2{1}.supp = new_imgs;
            n=length(db2);
            c0=cell(n,1);
            for s=1:n
                c0{s}=centroid_init(db2{s}.stride, db2{s}.supp, db2{s}.w, options);
            end
            
            [c2, OT2, new_time_taken]= Wasserstein_Barycenter(db2, c0, A, options);
            curr_time(j) = new_time_taken;
            [barycenter2, cost_new, old_cost_new] = wb_processing(OT2, db1, 2, supp, 4096, c1{1}.supp'); %wb_processing(OT2, db1, 10, supp, 784, c1{1}.supp');
            curr_accuracy(j) = cost_new;
            
        end
        
        time_values(d-1) = median(curr_time)/time_taken_orig;
        time_std(d-1) = std(curr_time)/time_taken_orig;
        accuracy_values(d-1) = median(curr_accuracy)/cost_orig;
        accuracy_std(d-1) = std(curr_accuracy)/cost_orig;
        
        
    end
    toc;
    
end