# FeelNet

This is the PyTorch implementation of the FeelNet using [DEAP](https://www.eecs.qmul.ac.uk/mmv/datasets/deap/) and [DREAMER](https://zenodo.org/record/546113) dataset in our paper:

Xueyao Wang, Xiuding Cai, Yaoyao Zhu, Yu Yao. FeelNet: A Lightweight Fast Fourier Transform EEG-based Emotion Recognition Network. ACML 2025.



## Abstract

Emotion recognition using Electroencephalography (EEG) is challenging due to its low signal-to-noise ratios and  high-dimensional sparsity. We propose FeelNet, a novel Fast Fourier Transform (FFT)-based architecture that simultaneously extracts global and local features across joint frequency-time domains. FeelNet incorporates an adaptive Rhythm Spectral Block (RSB) for capturing key frequency patterns and filtering task-irrelevant noise through power spectral thresholding. Additionally, the Multi-scale Temporal Conv Block (MTCB) enhances the model's ability to decode complex temporal dynamics. Extensive evaluations on the DEAP and DREAMER datasets demonstrate that FeelNet outperforms existing state-of-the-art methods in accuracy and flexibility, even under noise-contaminated conditions. Owing to its computational efficiency and noise resilience, FeelNet provides an alternative perspective for EEG-based affective computing.



## Prepare the python virtual environment

Please go to the working directory by:

> $ cd ./code

Please create an anaconda virtual environment by:

> $ conda create --name FeelNet python=3.8

Activate the virtual environment by:

> $ conda activate FeelNet

Install the requirements by:

> $ pip3 install -r requirements.txt



## Run the code

please save the data into a folder `./dataset` and set the path of the data in 'PrepareData.py'.

> python prepare_data_DEAP.py

Please place the "data_preprocessed_python" folder at the same location as the script (./code/).

To run the code for the arousal dimension, please type the following command in the terminal:

> $ python3 main-DEAP.py --data-path './data_preprocessed_python/' --label-type 'A'



## Acknowledgements

The codes in this repository are inspired by the following:

- TSception <https://github.com/deepBrains/TSception>
- TSLANet <https://github.com/emadeldeen24/TSLANet>