# RestoreLCC


## Installation
**Prepare Pruned Model.** Please follow Wanda https://arxiv.org/abs/2306.11695, SparseGPT https://proceedings.mlr.press/v202/frantar23a, or SlimGPT https://proceedings.neurips.cc/paper_files/paper/2024/hash/c1c44e46358e0fb94dc94ec495a7fb1a-Abstract-Conference.html to obtain a pruned LLM.

**Install evaluation environment.** Please follow wanda (https://github.com/locuslab/wanda) to modify and install the EleutherAI LM Harness framework (https://github.com/EleutherAI/lm-evaluation-harness).


## Run
```
python RestoreLCC_train.py --spec_task alpaca --num_train_samples 1000 --lr 1e-3 --use_topk_heads 256
```
It is noted we only provide 1000 Alpaca samples in the .zip file due to the file size limit. Please download the full Aplaca dataset (https://github.com/tatsu-lab/stanford_alpaca) to reproduce our results.

## Key Modules in RestoreLCC
1. Obtain main components lost due to pruning using Eqs. 3 and 4: utils/components.py

2. Train magnitudes and learned component: models/modeling_llama, line 258-380.


## Acknowledgements

We implement our code based on LoFiT and Wanda. Thank the authors for their excellent contribution!

```
@inproceedings{
      yin2024lofit,
      title={LoFiT: Localized Fine-tuning on {LLM} Representations},
      author={Fangcong Yin and Xi Ye and Greg Durrett},
      booktitle={The Thirty-eighth Annual Conference on Neural Information Processing Systems},
      year={2024},
      url={https://openreview.net/forum?id=dfiXFbECSZ}
}

@article{sun2023simple,
  title={A simple and effective pruning approach for large language models},
  author={Sun, Mingjie and Liu, Zhuang and Bair, Anna and Kolter, J Zico},
  journal={arXiv preprint arXiv:2306.11695},
  year={2023}
}

@misc{eval-harness,
  author       = {Gao, Leo and Tow, Jonathan and Abbasi, Baber and Biderman, Stella and Black, Sid and DiPofi, Anthony and Foster, Charles and Golding, Laurence and Hsu, Jeffrey and Le Noac'h, Alain and Li, Haonan and McDonell, Kyle and Muennighoff, Niklas and Ociepa, Chris and Phang, Jason and Reynolds, Laria and Schoelkopf, Hailey and Skowron, Aviya and Sutawika, Lintang and Tang, Eric and Thite, Anish and Wang, Ben and Wang, Kevin and Zou, Andy},
  title        = {The Language Model Evaluation Harness},
  month        = 07,
  year         = 2024,
  publisher    = {Zenodo},
  version      = {v0.4.3},
  doi          = {10.5281/zenodo.12608602},
  url          = {https://zenodo.org/records/12608602}
}
```
