# TAH-Quant

We explored how to quantize the activation tensor between PP stages on the fly.

## Setup:

- Create environment:

  We use nvcr.io/nvidia/cuda:11.0.3-cudnn8-devel-ubuntu20.04 as the base env.

- Install PyTorch env: 

  ```bash
  apt install python3.9 python3-pip

  python3.9 -m pip install numpy==1.23.5

  python3.9 -m pip install torch==2.1.0+cu118 torchtext==0.16.0 -f https://download.pytorch.org/whl/torch_stable.html

  python3.9 -m pip install cupy-cuda110==8.6.0

  python3.9 -m pip install datasets==3.6.0 
  python3.9 -m pip install multiprocess==0.70.12.2

  python3.9 -m pip install transformers==4.51.3

  python3.9 -m pip install scipy
  ```
  
- Setup network configuration:

  ```bash
  export GLOO_SOCKET_IFNAME=eth0
  export NCCL_SOCKET_IFNAME=eth0
  ```

## Run Distributed Gpipe:

- Partition the pre-trained model:
  
  ```bash
  # gpt2
  python3.9 convert_gpt2_checkpoint --model-name gpt2-xl --save-dir checkpoints/
  ```

- On each node, run:
  
  ```bash
  # gpt2
  python3.9 dist_lm_runner.py $(echo ${ARGS}) --cuda-id 0 --rank i # (i=0,...,N-1)
  ```
  where "ARGS" contains training-related configurations, which should remain the same across nodes. An example could be:
  ```bash
  ARGS="--model-name gpt2-xl \
  --tokenizer-name gpt2-xl \
  --load-pretrained-model true \
  --task-name wikitext --n-epochs 10 --warmup-epochs 0 \
  --num-layers 6 --num-heads 25 --embedding-dim 1600 \
  --num-iters 10000000 --lr 5e-6 --seq-length 1024 --batch-size 32 --micro-batch-size 1 \
  --forward-compress-method tah \
  --tile-size 64 \
  --high-precision-bits 4 \
  --low-precision-bits 3 \
  --high-precision-allocation-ratio 0.8 \
  --forward-bits 4 \
  --backward-compress-method fixpoint \
  --backward-tile-size 32 \
  --backward-bits 6 \
  --dist-url tcp://127.0.0.1:9033 \
  --world-size 8 --pipeline-group-size 8 \
  --pp-mode gpipe --profiling no-profiling --do-evaluation false"
  ```
  Modify `"--dist-url"`, `"--world-size"` and `"--pipeline-group-size"` before running.
  
  Complete examples can be found "./run_lm.sh" and "./run_lm_qwen.sh".
  
  
## Arguments

### Distributed Related

- `"--dist-url"`: tcp://XXX.XXX.XXX.XXX:9000
- `"--world-size"`: number of nodes that participate in the training.
- `"--pipeline-group-size"`: number of nodes that perform pipeline parallelism.
- `"--data-group-size"`: number of nodes that perform data parallelism.
- `"--rank"`: the rank of the current node. (0, ..., world_size-1)
- `"--profiling"`: "no-profiling" or "tidy_profiling". If "tidy_profiling", a trace file will be generated in "./trace_json/", which can be visualized with "chrome://tracing/".

### Compression Related

- `"--forward-compress-method"`: "none", "tha", "fixpoint", "delta", or "delta-lowbits".
  - "none": do not compress.
  - "tha": THA-Quant. need to specify "--tile-size", "--high-precision-bits", "--low-precision-bits", "--high-precision-allocation-ratio".
  - "fixpoint": direct compress the activations. need to specify `"--forward-bits".
  - "delta": compress and communicate the delta of activations. need to specify `"--forward-bits"` and `"--max-activation-cache-size"`.
  - "delta-lowbits": in addition to "delta", it also compresses the local cache (previous activations). need to specify `"--forward-bits"`, `"--forward-bits-act"`, and `"--max-activation-cache-size"`.
- `"--backward-compress-method"`: "none" or "fixpoint".
  - "none": do not compress.
  - "fixpoint": direct compress the gradients. need to specify `"--backward-bits"`.

### Training Related

- `"--batch-size"`: macro-batch size.
- `"--micro-batch-size "`: micro-batch-size. The macro-batch size should be divisible by micro-batch-size.
- `"--lr"`: the peak learning rate.
- `"--n-epochs"`: number of training epochs.
- `"--warmup-epochs"`: number of epochs for uncompressed training (transfer full-precision activations and gradients).
- `"--warmup-steps"`: number of training steps where the learning rate grows from 0 to `"--lr"`. Default to be one training epoch.
- `"--do-evaluation"`: whether do evaluation during training.

### Model Related

- `"--model-name"`: Name or path of the pretrained checkpoint. Usually should be a path to the checkpoint generated by "convert_xxx_checkpoint.py".
- `"--tokenizer-name"`: Name or path of the tokenizer.
- `"--load-pretrained-model"`: whether to load the pretrained checkpoint. The checkpoint should be generated by "convert_xxx_checkpoint.py".
- `"--num-layers", `"--num-heads", `"--embedding-dim"` should be inline with the configuration of `"--model-name"`.
