# TARS: MinMax Token-Adaptive Preference Strategy for Hallucination Reduction in MLLMs

## Dataset

- [AMBER](https://github.com/junyangwang0410/AMBER)
- [MMH](https://huggingface.co/datasets/Shengcao1006/MMHal-Bench)
- [OBJHal](https://github.com/RLHF-V/RLHF-V/blob/main/eval/eval_gpt_obj_halbench.py)
- [POPE](https://github.com/RUCAIBox/POPE)

## Environment Set up

```
conda create -n DPO python=3.10 -y
conda activate DPO
python -m pip install --upgrade pip
python -m pip install -e .
MAX_JOBS=64 python -m pip install --no-build-isolation flash-attn
pip install ftfy regex tqdm
python -m pip install -U spacy
python -m spacy download en_core_web_lg
python -m pip install nltk
python -m pip install openai scikit-learn
pip install git+https://github.com/openai/CLIP.git
```

## LLaVA-v1.5 Download

- liuhaotian/llava-v1.5-7b [Huggingface Page](https://huggingface.co/liuhaotian/llava-v1.5-7b)
- liuhaotian/llava-v1.5-13b [Huggingface Page](https://huggingface.co/liuhaotian/llava-v1.5-13b)

# Running Code

1. TARS Training

```
sh script/dpo.sh
```

2. MLLM VQA Inference

```
sh script/inference.sh
```

3. Evaluate Hallucination

```
sh script/evaluate_hallucination.sh
```
