#!/bin/bash

# Load Conda setup to ensure the "conda activate" command works
. ~/anaconda3/etc/profile.d/conda.sh

experiment_id_global=$(uuidgen | cut -c 1-8)


export base_path='llava_path'  # Base path for the model

# Function to run a task with a specific Conda environment
run_task() {
    local conda_env=$1       # Conda environment name
    local experiment_id=$2   # Experiment ID
    local cuda_device=$3     # GPU device
    local model_script=$4    # Path to the script
    local model_path=$5      # Path to the model
    local model_name=$6      # Model name
    local prompt_add=$7        # Prompt to add
    local record_words=$8        # Record words
    local dataset=$9        # Dataset root
    local dataset_root=${10}        # Dataset root
    local log_file=${11}        # Log file to store the output

    # Check if experiment_id is empty, generate a random one if needed
        if [ -z "$experiment_id" ]; then
            experiment_id=$experiment_id_global
            echo "Generated random Experiment ID: $experiment_id"
        fi

    # Run the task in the background
    {
        echo "Activating Conda environment: $conda_env"
        conda activate $conda_env

        echo "Experiment ID: $experiment_id"
        CUDA_VISIBLE_DEVICES=$cuda_device python $model_script \
            --dataset $dataset \
            --prompt_add $prompt_add \
            --experiment_id $experiment_id \
            --record_words $record_words \
            --dataset_root $dataset_root \
            --model_path $model_path \
            --debug False \
            --model $model_name \
            --model_base_path $base_path \
            --record_path record
        conda deactivate
        echo "Task with Experiment ID $experiment_id completed."
    } 
    > $log_file 2>&1 &  # Redirect both stdout and stderr to the log file, and run in the background
}

run_task llava "" 7 inference.py \
    model_weight_path model_name  None None Dataset_name Dataset_path log_temp/llava_chip_0.log

# Wait for all background tasks to complete
wait
echo "All tasks completed."