from ... import utils  # 上上级目录import
from ...pipeline.utils import check_local_file
from .clip import CustomCLIP


def build_encoder(config):
    with utils.transformers_log_level(40):  # 40 == logging.ERROR
        if config.encoder_type == "openai.clip":
            # vm_local_files_only, vm_file_name = check_local_file(config.pretrained_vision_name_or_path)
            # model = CustomCLIP.from_pretrained(
            #     vm_file_name,
            #     local_files_only=vm_local_files_only,
            # )
            
            # 可以这样初始化了模型,但没有加载权重,再后面统一加载。
            # 所以huggingface的config文件是用来配置模型架构的,权重由.bin或.pth存储,用from_pretrained加载
            # 类似torch.load和model()实例化的区别。
            model = CustomCLIP(config=config)  # CLIP没有提供from_config API,直接用传统的config=config只初始化模型。
        else:
            raise NotImplementedError()

    return model
