# HoloLLM: Multisensory Foundation Model for Language-Grounded Human Sensing and Reasoning

This is the code implementation of our Paper "HoloLLM: Multisensory Foundation Model for Language-Grounded Human Sensing and Reasoning"


## Prepare the datasets
Download and prepare data [MM-Fi](https://ntu-aiot-lab.github.io/mm-fi) and [XRF55](https://github.com/aiotgroup/XRF55-repo) as follows.

- MM-Fi
``` text  
MM-Fi/
├── E01/
│ ├── S01/
│ │ ├── A01/
│ │ │ ├── RGB/
│ │ │ ├── Depth/
│ │ │ ├── mmWave/
│ │ │ ├── LiDAR/
│ │ │ └── WiFi/
│ │ ├── A02/
│ │ └── ...
│ ├── S02/
│ └── ...
├── E02/
├── E03/
└── E04/
```

- XRF55
``` text 
XRF55/
├── Scene1/
│ ├── RGB/
│ │ ├── 001/
│ │ ├── 002/
│ │ ├── ...
│ │ └── 010/
│ ├── Depth/
│ ├── IR/
│ ├── RFID/
│ └── WiFi/
├── Scene2/
├── Scene3/
└── Scene4/
```

## Training
We provide both .sh and .slurm scripts for training. Take training HoloLLM under 'Cross-Environment' on MM-Fi dataset as an example.

  - Bash Script
    ```
    bash ./scripts_sh/holollm_mmfi_ce.sh
    ```

  - Slurm Script
    ```
    sbatch ./scripts_slurm/holollm_mmfi_ce.slurm
    ```

## Testing

We provide the testing script for each model.  Take testing HoloLLM under 'Cross-Environment' on MM-Fi dataset as an example.

Set the 'exp_settings' in the testing script to 'cross_env', then run
```
python ./eval/holollm_eval_mmfi.py
```
 