def to_ordinal(number):
    ''' converts an integer to its ordinal string representation (e.g., 1st, 2nd, 3rd) '''
    if not isinstance(number, int):
        raise TypeError("Input must be an integer.")

    if 10 <= number % 100 <= 20:  # Handles 11th, 12th, 13th, etc.
        suffix = "th"
    else:
        last_digit = number % 10
        if last_digit == 1:
            suffix = "st"
        elif last_digit == 2:
            suffix = "nd"
        elif last_digit == 3:
            suffix = "rd"
        else:
            suffix = "th"

    return str(number) + suffix