def normalize(text):
    return text.replace('-', '').lower()

def process_results_gen(doc: dict, results: list[str]) -> dict[str, float]:
    max_logprob_idx = max(range(len(results)), key=lambda i: results[i][0])
    is_correct = 1.0 if max_logprob_idx == doc["answer_idx"] else 0.0
    return {doc["category"]: is_correct}
