from transformers import AutoTokenizer, pipeline
import torch
from easyeditor.dataset.test import testCounterFactDataset
from easyeditor.evaluate.evaluate import compute_edit_quality,compute_rewrite_or_rephrase_quality,compute_locality_quality,compute_portability_quality 
transdict={
"English": ["English","Japanese","German","Greek","Chinese"],
"Islam":["Islam","Buddhism", "Hinduism", "Christianity", "Judaism"],
"piano":["piano", "violin", "cello", "flute", "drum"],
"Sweden":["Sweden","Norway", "Denmark", "Finland", "Iceland"],
"Manila":["Manila","Tokyo", "Beijing", "New York", "London"],
"Philadelphia":["Philadelphia","New York", "Los Angeles"," Chicago", "Houston"],
"Google":["Google", "Amazon", "Nvidia", "Facebook", "Microsoft"],
"Sheffield":["Sheffield","Liverpool", "Leeds", "Manchester", "Birmingham"] 
}
device = torch.device("cuda:0") if torch.cuda.is_available() else torch.device("cpu")
tokenizer = AutoTokenizer.from_pretrained("/home/ssliang/tangent_ta/opt-1.3b")
generator = pipeline('text-generation', model="/home/ssliang/tangent_ta/src/bytedance_unlearn/models/opt1.3b_learnedcounterfactaugmented0.05", tokenizer=tokenizer,max_length=100,device=device)
dataset=testCounterFactDataset('/home/ssliang/tangent_ta/data/counterfact.json')
#print(dataset)
answernew=dataset[0]['raw']['requested_rewrite']['target_new']['str'][0]
print(answernew)
if answernew in transdict:
     answerrevised=transdict.get(answernew)
print(answerrevised)
"""
with open('./generate_answernew.csv', 'w', encoding='utf-8') as file:
     for line in answernew:
         print(line)
         file.write(line)
""" 
