## Idea Generation
- output_gpt5.json: contains the list of ideas generated by GPT-5

- chat_interface_01 and chat_interface_02: images showing the chat interface and prompts used to generate the list of ideas and revise the selected idea

- idea_chosen.json: the selected idea used in this research


## Code

- Installation:
```
pip install -r requirements.txt
```

- Full results: 
```
python3 main_local_all_new.py 
```

- With Oracle evaluation:
```
python3 main_local_all_new.py --oracle
```


## log_code_generation_roo_code.md
- All logs used to generate the main code for this research (using Claude Opus via Roo Code). 

- It should be noted that we remove certain information that could reveal user details, such as usernames, locations, and time zones.


## References:

- Insert references in an existing section:
```
python references/inject.py             \
    --model "gpt-5"                     \
    --section-tex to-inject.tex         \   # Source text where citations are inserted
    --out-path section-injected.tex     \   # Output .tex file
    --openai-key <key>                      # OpenAI key
```


- Reflection for references:
```
python references/check.py          \
    --model "gpt-5"                 \
    --section-tex to-check.tex      \   # Source text to check
    --out-path section-checked.tex  \   # Output .tex file
    --openai-key <key>                  # OpenAI key
```


```
python references/main.py       \
    --text-path to-parse.tex    \   # Source text for which citations are parsed
    --out-dir ref-parsed        \   # Directory where the output is saved
```