# In this script, we download the Supplementary Material and run the experiments with following commands
# https://openreview.net/forum?id=n1bLgxHW6jW
# Shu, Yao, et al. "Zeroth-Order Optimization with Trajectory-Informed Derivative Estimation." The Eleventh International Conference on Learning Representations. 2022.

# random starting point
# Ackley 20d
# ZoRD
python run_exp.py --alg zord --n_inits 10 --gd_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_ZoRD
# gd
python run_exp.py --alg gd --n_inits 10 --gd_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_gd
# gld
python run_exp.py --alg gld --n_inits 10 --gd_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_gld
# rgf
python run_exp.py --alg rgf --n_inits 10 --gd_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_rgf
# prgf
python run_exp.py --alg prgf --n_inits 10 --gd_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_prgf
# gp_ucb
python run_exp.py --alg gp_ucb --n_inits 10 --bo_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_gp_ucb
# turbo
python run_exp.py --alg turbo1 --bo_iters 200 --func Ackley --dim 20 --n_runs 10 --lb -20 --ub 20 --save Ackley20_turbo



# Ackley 40d
# ZoRD
python run_exp.py --alg zord --n_inits 10 --gd_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_ZoRD
# gld
python run_exp.py --alg gld --n_inits 10 --gd_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_gld
# gd
python run_exp.py --alg gd --n_inits 10 --gd_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_gd
# rgf
python run_exp.py --alg rgf --n_inits 10 --gd_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_rgf
# prgf
python run_exp.py --alg prgf --n_inits 10 --gd_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_prgf
# gp_ucb
python run_exp.py --alg gp_ucb --n_inits 10 --bo_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_gp_ucb
# turbo
python run_exp.py --alg turbo1 --bo_iters 200 --func Ackley --dim 40 --n_runs 10 --lb -20 --ub 20 --save Ackley40_turbo



# Ackley 1000d
# ZoRD
python run_exp.py --alg zord --n_inits 10 --gd_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_ZoRD
# gld
python run_exp.py --alg gld --n_inits 10 --gd_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_gld
# gd
python run_exp.py --alg gd --n_inits 10 --gd_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_gd
# rgf
python run_exp.py --alg rgf --n_inits 10 --gd_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_rgf
# prgf
python run_exp.py --alg prgf --n_inits 10 --gd_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_prgf
# gp_ucb
python run_exp.py --alg gp_ucb --n_inits 10 --bo_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_gp_ucb
# turbo
python run_exp.py --alg turbo1 --bo_iters 200 --func Ackley --dim 1000 --n_runs 10 --lb -20 --ub 20 --save Ackley1000_turbo



# Levy 40d
# Turbo
python run_exp.py --alg turbo1 --bo_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_turbo
# ZoRD
python run_exp.py --alg zord --n_inits 10 --gd_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_ZoRD
# gld
python run_exp.py --alg gld --n_inits 10 --gd_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_gld
# gd
python run_exp.py --alg gd --n_inits 10 --gd_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_gd
# rgf
python run_exp.py --alg rgf --n_inits 10 --gd_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_rgf
# prgf
python run_exp.py --alg prgf --n_inits 10 --gd_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_prgf
# gp_ucb
python run_exp.py --alg gp_ucb --n_inits 10 --bo_iters 200 --func Levy --dim 40 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy40_gp_ucb




# Levy 100d
# Turbo
python run_exp.py --alg turbo1 --bo_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_turbo
# ZoRD
python run_exp.py --alg zord --n_inits 10 --gd_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_ZoRD
# gld
python run_exp.py --alg gld --n_inits 10 --gd_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_gld
# gd
python run_exp.py --alg gd --n_inits 10 --gd_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_gd
# rgf
python run_exp.py --alg rgf --n_inits 10 --gd_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_rgf
# prgf
python run_exp.py --alg prgf --n_inits 10 --gd_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_prgf
# gp_ucb
python run_exp.py --alg gp_ucb --n_inits 10 --bo_iters 200 --func Levy --dim 100 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy100_gp_ucb


# Levy 1000d
# Turbo
python run_exp.py --alg turbo1 --bo_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_turbo
# ZoRD
python run_exp.py --alg zord --n_inits 10 --gd_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_ZoRD
# gld
python run_exp.py --alg gld --n_inits 10 --gd_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_gld
# gd
python run_exp.py --alg gd --n_inits 10 --gd_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_gd
# rgf
python run_exp.py --alg rgf --n_inits 10 --gd_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_rgf
# prgf
python run_exp.py --alg prgf --n_inits 10 --gd_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_prgf
# gp_ucb
python run_exp.py --alg gp_ucb --n_inits 10 --bo_iters 200 --func Levy --dim 1000 --n_runs 10 --lb -7.5 --ub 7.5 --save Levy1000_gp_ucb


