# Generalization Error Minimized Deep Learning

This repo is for reproducing the CIFAR-100 experimental results in our paper *Generalization Error Minimized Deep Learning*.

## Installation

The repo is tested with Python 3.8, PyTorch 2.0.1, and CUDA 11.7.

## Running

1. An example of running Generalization Error Minimization (GEM) is given by:
    ```
    python3 train.py --model MobileNetV2 --trial 1
    ```
    where the flags are explained as:
    - `--model`: specify the model architecture. See 'models/\_\_init\_\_.py' to check the available model types.
    - `--trial`: specify the experiment id to differentiate between multiple runs.

2. The resulting log file of an experiment recording accuracies and losses after each training epoch is saved in `save`.

Note: the default setting is for a single-GPU training. If you would like to play this repo with multiple GPUs, you might need to tune the learning rate, which empirically needs to be scaled up linearly with the batch size, see [this paper](https://arxiv.org/abs/1706.02677)
