﻿using System.Globalization;
using CsvHelper;

namespace Robotless.Modules.Mocking.Demo;

public static class DataLoader
{
    public static IEnumerable<TDataEntry> FromCsv<TDataEntry>(string path)
    {
        var streamReader = new StreamReader(path);
        var csvReader = new CsvReader(streamReader, CultureInfo.InvariantCulture);
        return csvReader.GetRecords<TDataEntry>();
    }
    
    public static TDataEntry[] FromCsvShuffled<TDataEntry>(string path, int? seed = null)
    {
        var streamReader = new StreamReader(path);
        var csvReader = new CsvReader(streamReader, CultureInfo.InvariantCulture);
        var records = csvReader.GetRecords<TDataEntry>().ToArray();
        var random = seed == null ? new Random() : new Random(seed.Value);
        random.Shuffle(records);
        return records;
    }
    
    public static IEnumerable<TDataEntry> FromCsvSkipped<TDataEntry>(string path, 
        int? maxSkips = null, int? seed = null)
    {
        var streamReader = new StreamReader(path);
        var csvReader = new CsvReader(streamReader, CultureInfo.InvariantCulture);
        var data = csvReader.GetRecords<TDataEntry>();
        if (maxSkips == null) 
            return data;
        var random = seed == null ? new Random() : new Random(seed.Value);
        var skip = random.Next(0, maxSkips.Value);
        data = data.Skip(skip);
        return data;
    }
    
    public static TDataEntry[] FromCsvSkippedShuffled<TDataEntry>(string path, int count,
        int? maxSkips = null, int? seed = null)
    {
        var streamReader = new StreamReader(path);
        var csvReader = new CsvReader(streamReader, CultureInfo.InvariantCulture);
        var data = csvReader.GetRecords<TDataEntry>();
        var random = seed == null ? new Random() : new Random(seed.Value);
        if (maxSkips != null)
        {
            var skip = random.Next(0, maxSkips.Value);
            data = data.Skip(skip);
        }
        var records = data.Take(count).ToArray();
        random.Shuffle(records);
        return records;
    }
}