using JetBrains.Annotations;
using Robotless.Modules.Mocking.Demo.Utilities;

namespace Robotless.Modules.Mocking.Demo.Providers;

public static class OllamaProvider
{
    public static void AddOllamaModels(this IList<ModelConfiguration> models)
    {
        AddOllamaModel(models, "qwen2.5:72b");
        AddOllamaModel(models, "qwen2.5:32b");
        AddOllamaModel(models, "qwen2.5:14b");
        AddOllamaModel(models, "qwen2.5:7b");
        AddOllamaModel(models, "qwen2.5:3b");
        AddOllamaModel(models, "qwen2.5:1.5b");
        AddOllamaModel(models, "qwen2.5:0.5b");
        
        AddOllamaModel(models, "llama3.2-vision:11b");
        AddOllamaModel(models, "llama3.2:3b");
        AddOllamaModel(models, "llama3.2:1b");
        AddOllamaModel(models, "llama3.1:70b");
        AddOllamaModel(models, "llama3.1:8b");
        
        AddOllamaModel(models, "mistral:latest");
        AddOllamaModel(models, "gemma2:9b");

        void AddOllamaModel(IList<ModelConfiguration> list, [IgnoreSpellingAndGrammarErrors] string model)
        {
            list.Add(new ModelConfiguration()
            {
                ApiKey = "-",
                ApiUrl = Environment.GetEnvironmentVariable("OLLAMA_URL")!,
                Name = model,
                Provider = "Ollama",
                SupportStructuredOutput = false
            });
        }
    }
}