using JetBrains.Annotations;
using Robotless.Modules.Mocking.Demo.Utilities;

namespace Robotless.Modules.Mocking.Demo.Providers;

public static class OpenAiProvider
{
    public static void AddOpenAiModels(this IList<ModelConfiguration> models)
    {
        AddOpenAiModel(models, "gpt-4o", true);
        AddOpenAiModel(models, "gpt-4o-mini", true);
        AddOpenAiModel(models, "gpt-4-turbo");
        AddOpenAiModel(models, "gpt-3.5-turbo");

        void AddOpenAiModel(IList<ModelConfiguration> list, [IgnoreSpellingAndGrammarErrors] string model, bool supportStructuredOutput = false)
        {
            list.Add(new ModelConfiguration()
            {
                ApiKey = Environment.GetEnvironmentVariable("OPENAI_API_KEY")!,
                ApiUrl = "https://api.openai.com/v1",
                Name = model,
                Provider = "OpenAI",
                SupportStructuredOutput = supportStructuredOutput
            });
        }
    }
}