﻿namespace Robotless.Modules.Mocking.Demo.Utilities;

public static class DataExtensions
{
    public static TData[] Shuffle<TData>(this TData[] data, int? seed = null)
    {
        var random = seed == null ? new Random() : new Random(seed.Value);
        random.Shuffle(data);
        return data;
    }
    
    public static TData[] Shuffle<TData>(this IEnumerable<TData> data, int? seed = null)
    {
        var array = data.ToArray();
        var random = seed == null ? new Random() : new Random(seed.Value);
        random.Shuffle(array);
        return array;
    }
}