using System.Net;
using System.Net.Mail;
using System.Text;
using JetBrains.Annotations;

namespace Robotless.Modules.Mocking.Demo.Utilities;

public class MailNotifier
{
    private readonly SmtpClient _client;
    
    public required MailAddress FromAddress { get; init; }
    
    public required MailAddress ToAddress { get; init; }
    
    public MailNotifier(string host, string username, string password)
    {
        _client = new SmtpClient(host);
        _client.UseDefaultCredentials = false;
        _client.Credentials = new NetworkCredential(username, password);
    }
    
    public void Send(string title, [LanguageInjection("html")] string body)
    {
        var message = new MailMessage(FromAddress, ToAddress)
        {
            SubjectEncoding = Encoding.UTF8,
            Subject = title,
            BodyEncoding = Encoding.UTF8,
            Body = body,
            IsBodyHtml = true
        };
        _client.Send(message);
    }
}