﻿using System.ClientModel;
using OpenAI;

namespace Robotless.Modules.Agenting.Clients;

public class CerebrasAgent(ApiKeyCredential credential, string model, OpenAIClientOptions? options = null) : 
    OpenAiAgent(credential, model, CreateOptions(options))
{
    public CerebrasAgent(string key, string model) : this(new ApiKeyCredential(key), model)
    {}
    
    private static OpenAIClientOptions CreateOptions(OpenAIClientOptions? options)
    {
        return options == null
            ? new OpenAIClientOptions
            {
                Endpoint = new Uri("https://api.cerebras.ai/"),
            }
            : new OpenAIClientOptions
            {
                Endpoint = new Uri("https://api.cerebras.ai/"),
                NetworkTimeout = options.NetworkTimeout,
                OrganizationId = options.OrganizationId,
                ProjectId = options.ProjectId,
                RetryPolicy = options.RetryPolicy,
                Transport = options.Transport
            };
    }
}

public static class CerebrasAgentFactory
{
    public static IInjectionContainer AddCerebrasAgent(this IInjectionContainer container, 
        ApiKeyCredential key, string model, OpenAIClientOptions? options = null)
    {
        container[typeof(CerebrasAgent)] = CreateAgent;
        
        return container;
        
        CerebrasAgent CreateAgent(IInjectionProvider provider, InjectionTarget? target)
        {
            return new CerebrasAgent(key, model, options)
            {
                Logger = provider.GetInjection<IPlatformLogger>()
            };
        }
    }
}