﻿using OpenAI.Chat;

namespace Robotless.Modules.Agenting;

public interface IAgent
{
    /// <summary>
    /// Tools that assigned to this agent to use.
    /// </summary>
    IDictionary<string, ITool> Tools { get; }
    
    /// <summary>
    /// Complete a memory.
    /// </summary>
    /// <remarks>
    /// Response message will be automatically added to the memory.
    /// </remarks>
    public Task<AgentAssistantMessage> Complete(IAgentMemory memory, 
        ChatCompletionOptions? options = null, IReadOnlyDictionary<string, ITool>? tools = null,
        CancellationToken cancellation = default);
}